/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.account;

import com.gooddata.AbstractService;
import com.gooddata.GoodDataException;
import com.gooddata.account.Account;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class AccountService
extends AbstractService {
    public AccountService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public Account getCurrent() {
        try {
            return (Account)this.restTemplate.getForObject("/gdc/account/profile/{id}", Account.class, new Object[]{"current"});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to get current account", e);
        }
    }

    public void logout() {
        try {
            String id = this.getCurrent().getId();
            this.restTemplate.delete("/gdc/account/login/{id}", new Object[]{id});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to logout", e);
        }
    }
}

