/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.gdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;

@JsonTypeName(value="about")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Gdc {
    public static final String URI = "/gdc";
    private final List<Link> links;

    @JsonCreator
    public Gdc(@JsonProperty(value="links") List<Link> links) {
        this.links = links;
    }

    @JsonIgnore
    public String getHomeLink() {
        return this.getLink(LinkCategory.HOME).getUri();
    }

    @JsonIgnore
    public String getTokenLink() {
        return this.getLink(LinkCategory.TOKEN).getUri();
    }

    @JsonIgnore
    public String getLoginLink() {
        return this.getLink(LinkCategory.LOGIN).getUri();
    }

    @JsonIgnore
    public String getMetadataLink() {
        return this.getLink(LinkCategory.METADATA).getUri();
    }

    @JsonIgnore
    public String getXTabLink() {
        return this.getLink(LinkCategory.XTAB).getUri();
    }

    @JsonIgnore
    public String getAvailableElementsLink() {
        return this.getLink(LinkCategory.AVAILABLE_ELEMENTS).getUri();
    }

    @JsonIgnore
    public String getReportExporterLink() {
        return this.getLink(LinkCategory.REPORT_EXPORTER).getUri();
    }

    @JsonIgnore
    public String getAccountLink() {
        return this.getLink(LinkCategory.ACCOUNT).getUri();
    }

    @JsonIgnore
    public String getProjectsLink() {
        return this.getLink(LinkCategory.PROJECTS).getUri();
    }

    @JsonIgnore
    public String getToolLink() {
        return this.getLink(LinkCategory.TOOL).getUri();
    }

    @JsonIgnore
    public String getTemplatesLink() {
        return this.getLink(LinkCategory.TEMPLATES).getUri();
    }

    @JsonIgnore
    public String getReleaseInfoLink() {
        return this.getLink(LinkCategory.RELEASE_INFO).getUri();
    }

    @JsonIgnore
    public String getUserStagingLink() {
        return this.getLink(LinkCategory.USER_STAGING).getUri();
    }

    @JsonIgnore
    private Link getLink(LinkCategory category) {
        for (Link link : this.links) {
            if (!category.value.equals(link.getCategory())) continue;
            return link;
        }
        return null;
    }

    private static enum LinkCategory {
        HOME("home"),
        TOKEN("token"),
        LOGIN("login"),
        METADATA("md"),
        XTAB("xtab"),
        AVAILABLE_ELEMENTS("availablelements"),
        REPORT_EXPORTER("report-exporter"),
        ACCOUNT("account"),
        PROJECTS("projects"),
        TOOL("tool"),
        TEMPLATES("templates"),
        RELEASE_INFO("releaseInfo"),
        USER_STAGING("uploads");

        private final String value;

        private LinkCategory(String value) {
            this.value = value;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Link {
        private final String category;
        private final String link;
        private final String summary;
        private final String title;

        @JsonCreator
        public Link(@JsonProperty(value="category") String category, @JsonProperty(value="link") String link, @JsonProperty(value="summary") String summary, @JsonProperty(value="title") String title) {
            this.category = category;
            this.link = link;
            this.summary = summary;
            this.title = title;
        }

        public String getCategory() {
            return this.category;
        }

        public String getUri() {
            return this.link;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

