/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.PollHandler;
import com.gooddata.util.Validate;
import java.util.concurrent.TimeUnit;

public final class PollResult<T>
implements FutureResult<T> {
    private final AbstractService service;
    private final PollHandler<?, T> handler;

    public PollResult(AbstractService service, PollHandler<?, T> handler) {
        this.service = Validate.notNull(service, "service");
        this.handler = Validate.notNull(handler, "handler");
    }

    @Override
    public boolean isDone() {
        return this.handler.isDone() || this.service.pollOnce(this.handler);
    }

    @Override
    public T get() {
        return this.get(0L, null);
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        if (this.handler.isDone()) {
            return this.handler.getResult();
        }
        return this.service.poll(this.handler, timeout, unit);
    }

    @Override
    public String getPollingUri() {
        return this.handler.getPollingUri();
    }
}

