/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.gooddata.UriPrefixer;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.util.UriComponentsBuilder;

class UriPrefixingClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final ClientHttpRequestFactory wrapped;
    private final UriPrefixer prefixer;

    UriPrefixingClientHttpRequestFactory(ClientHttpRequestFactory factory, URI uriPrefix) {
        this.wrapped = Validate.notNull(factory, "factory");
        this.prefixer = new UriPrefixer(uriPrefix);
    }

    UriPrefixingClientHttpRequestFactory(ClientHttpRequestFactory factory, String hostname, int port, String protocol) {
        this(factory, UriComponentsBuilder.newInstance().scheme(protocol).host(hostname).port(port).build().toUri());
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return this.wrapped.createRequest(this.prefixer.mergeUris(uri), httpMethod);
    }
}

