/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.connector;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.gooddata.connector.ConnectorType;
import com.gooddata.connector.ProcessExecution;
import com.gooddata.util.Validate;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Zendesk4ProcessExecution
implements ProcessExecution {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    private Boolean incremental;
    private Map<String, String> startTimes;

    @Override
    public ConnectorType getConnectorType() {
        return ConnectorType.ZENDESK4;
    }

    public Boolean getIncremental() {
        return this.incremental;
    }

    public void setIncremental(Boolean incremental) {
        this.incremental = incremental;
    }

    @JsonAnyGetter
    public Map<String, String> getStartTimes() {
        return this.startTimes;
    }

    public void setStartTime(String resource, DateTime startTime) {
        Validate.notEmpty(resource, "resource can't be empty");
        Validate.notNull(startTime, "startTime can't be null");
        this.startTimes = this.startTimes == null ? new TreeMap() : this.startTimes;
        this.startTimes.put(resource + "StartDate", FORMATTER.print((ReadableInstant)startTime));
    }
}

