/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Meta;
import com.gooddata.md.Queryable;
import com.gooddata.util.Validate;
import java.util.Collection;
import java.util.Objects;

@JsonTypeName(value="projectDashboard")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectDashboard
extends AbstractObj
implements Queryable {
    private final Content content;

    private ProjectDashboard(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = Validate.notNull(content, "content");
    }

    @JsonIgnore
    public Collection<Tab> getTabs() {
        return this.content.tabs;
    }

    @JsonIgnore
    public Tab getTabByName(String name) {
        for (Tab tab : this.getTabs()) {
            if (!Objects.equals(tab.title, name)) continue;
            return tab;
        }
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Tab {
        private final String identifier;
        private final String title;

        @JsonCreator
        private Tab(@JsonProperty(value="identifier") String identifier, @JsonProperty(value="title") String title) {
            this.identifier = identifier;
            this.title = title;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getTitle() {
            return this.title;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Content {
        private final Collection<Tab> tabs;

        @JsonCreator
        private Content(@JsonProperty(value="tabs") Collection<Tab> tabs) {
            this.tabs = tabs;
        }
    }
}

