/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataload.processes;

import com.gooddata.AbstractPollHandler;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.PollResult;
import com.gooddata.SimplePollHandler;
import com.gooddata.account.AccountService;
import com.gooddata.collections.Page;
import com.gooddata.collections.PageableList;
import com.gooddata.dataload.processes.AsyncTask;
import com.gooddata.dataload.processes.DataloadProcess;
import com.gooddata.dataload.processes.DataloadProcesses;
import com.gooddata.dataload.processes.ProcessExecution;
import com.gooddata.dataload.processes.ProcessExecutionDetail;
import com.gooddata.dataload.processes.ProcessExecutionException;
import com.gooddata.dataload.processes.ProcessExecutionTask;
import com.gooddata.dataload.processes.ProcessNotFoundException;
import com.gooddata.dataload.processes.Schedule;
import com.gooddata.dataload.processes.ScheduleNotFoundException;
import com.gooddata.dataload.processes.Schedules;
import com.gooddata.gdc.DataStoreService;
import com.gooddata.project.Project;
import com.gooddata.util.ZipHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.Validate;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ProcessService
extends AbstractService {
    private static final MediaType MEDIA_TYPE_ZIP = MediaType.parseMediaType((String)"application/zip");
    private static final long MAX_MULTIPART_SIZE = 0x100000L;
    private final AccountService accountService;
    private final DataStoreService dataStoreService;

    public ProcessService(RestTemplate restTemplate, AccountService accountService, DataStoreService dataStoreService) {
        super(restTemplate);
        this.dataStoreService = dataStoreService;
        this.accountService = com.gooddata.util.Validate.notNull(accountService, "accountService");
    }

    public DataloadProcess createProcess(Project project, DataloadProcess process, File processData) {
        com.gooddata.util.Validate.notNull(process, "process");
        com.gooddata.util.Validate.notNull(processData, "processData");
        com.gooddata.util.Validate.notNull(project, "project");
        Validate.isTrue((process.getPath() == null ? 1 : 0) != 0, (String)"Process path has to be null, use processData argument. If you want to create process from appstore, use method createProcessFromAppstore()");
        return this.postProcess(process, processData, ProcessService.getProcessesUri(project));
    }

    public DataloadProcess createProcess(Project project, DataloadProcess process) {
        com.gooddata.util.Validate.notNull(project, "project");
        com.gooddata.util.Validate.notNull(process, "process");
        Validate.isTrue((process.getPath() == null ? 1 : 0) != 0, (String)"Process path has to be null. If you want to create process from appstore, use method createProcessFromAppstore()");
        return this.postProcess(process, ProcessService.getProcessesUri(project));
    }

    public FutureResult<DataloadProcess> createProcessFromAppstore(Project project, DataloadProcess process) {
        com.gooddata.util.Validate.notNull(project, "project");
        com.gooddata.util.Validate.notNull(process, "process");
        com.gooddata.util.Validate.notEmpty(process.getPath(), "process path must not be empty");
        return this.postProcess(process, ProcessService.getProcessesUri(project), HttpMethod.POST);
    }

    public DataloadProcess updateProcess(Project project, DataloadProcess process, File processData) {
        com.gooddata.util.Validate.notNull(process, "process");
        com.gooddata.util.Validate.notNull(processData, "processData");
        com.gooddata.util.Validate.notNull(project, "project");
        Validate.isTrue((process.getPath() == null ? 1 : 0) != 0, (String)"Process path has to be null, use processData argument. If you want to update process from appstore, use method updateProcessFromAppstore()");
        return this.postProcess(process, processData, ProcessService.getProcessUri(project, process.getId()));
    }

    public FutureResult<DataloadProcess> updateProcessFromAppstore(Project project, DataloadProcess process) {
        com.gooddata.util.Validate.notNull(project, "project");
        com.gooddata.util.Validate.notNull(process, "process");
        com.gooddata.util.Validate.notEmpty(process.getPath(), "process path must not be empty");
        return this.postProcess(process, ProcessService.getProcessUri(project, process.getId()), HttpMethod.PUT);
    }

    public DataloadProcess getProcessByUri(String uri) {
        com.gooddata.util.Validate.notEmpty(uri, "uri");
        try {
            return (DataloadProcess)this.restTemplate.getForObject(uri, DataloadProcess.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ProcessNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get process " + uri, e);
        }
    }

    public DataloadProcess getProcessById(Project project, String id) {
        com.gooddata.util.Validate.notEmpty(id, "id");
        com.gooddata.util.Validate.notNull(project, "project");
        return this.getProcessByUri(ProcessService.getProcessUri(project, id).toString());
    }

    public Collection<DataloadProcess> listProcesses(Project project) {
        com.gooddata.util.Validate.notNull(project, "project");
        return this.listProcesses(ProcessService.getProcessesUri(project));
    }

    public Collection<DataloadProcess> listUserProcesses() {
        return this.listProcesses(DataloadProcesses.USER_PROCESSES_TEMPLATE.expand(new Object[]{this.accountService.getCurrent().getId()}));
    }

    public void removeProcess(DataloadProcess process) {
        com.gooddata.util.Validate.notNull(process, "process");
        try {
            this.restTemplate.delete(process.getUri(), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to remove process " + process.getUri(), e);
        }
    }

    public void getProcessSource(DataloadProcess process, OutputStream outputStream) {
        com.gooddata.util.Validate.notNull(process, "process");
        com.gooddata.util.Validate.notNull(outputStream, "outputStream");
        try {
            this.restTemplate.execute(process.getSourceLink(), HttpMethod.GET, null, (ResponseExtractor)new AbstractService.OutputStreamResponseExtractor(outputStream), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to get process source " + process.getSourceLink(), e);
        }
    }

    public void getExecutionLog(ProcessExecutionDetail executionDetail, OutputStream outputStream) {
        com.gooddata.util.Validate.notNull(executionDetail, "executionDetail");
        com.gooddata.util.Validate.notNull(outputStream, "outputStream");
        try {
            this.restTemplate.execute(executionDetail.getLogLink(), HttpMethod.GET, null, (ResponseExtractor)new AbstractService.OutputStreamResponseExtractor(outputStream), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to get process execution log " + executionDetail.getLogLink(), e);
        }
    }

    public FutureResult<ProcessExecutionDetail> executeProcess(ProcessExecution execution) {
        ProcessExecutionTask executionTask;
        com.gooddata.util.Validate.notNull(execution, "execution");
        try {
            executionTask = (ProcessExecutionTask)this.restTemplate.postForObject(execution.getExecutionsUri(), (Object)execution, ProcessExecutionTask.class, new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new ProcessExecutionException("Cannot execute process", e);
        }
        if (executionTask == null) {
            throw new ProcessExecutionException("Cannot find started execution.");
        }
        final String detailLink = executionTask.getDetailLink();
        return new PollResult<ProcessExecutionDetail>(this, new AbstractPollHandler<Void, ProcessExecutionDetail>(executionTask.getPollLink(), Void.class, ProcessExecutionDetail.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.NO_CONTENT.equals((Object)response.getStatusCode());
            }

            @Override
            public void handlePollResult(Void pollResult) {
                ProcessExecutionDetail executionDetail = this.getProcessExecutionDetailByUri(detailLink);
                if (!executionDetail.isSuccess()) {
                    throw new ProcessExecutionException("Execution was not successful", executionDetail);
                }
                this.setResult(executionDetail);
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                ProcessExecutionDetail detail = null;
                try {
                    detail = this.getProcessExecutionDetailByUri(detailLink);
                }
                catch (GoodDataException goodDataException) {
                    // empty catch block
                }
                throw new ProcessExecutionException("Can't execute " + e.getText(), detail, e);
            }

            private ProcessExecutionDetail getProcessExecutionDetailByUri(String uri) {
                try {
                    return (ProcessExecutionDetail)ProcessService.this.restTemplate.getForObject(uri, ProcessExecutionDetail.class, new Object[0]);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new ProcessExecutionException("Execution finished, but cannot get its result.", e, uri);
                }
            }
        });
    }

    public Schedule createSchedule(Project project, Schedule schedule) {
        com.gooddata.util.Validate.notNull(schedule, "schedule");
        com.gooddata.util.Validate.notNull(project, "project");
        return this.postSchedule(schedule, ProcessService.getSchedulesUri(project));
    }

    public Schedule updateSchedule(Project project, Schedule schedule) {
        com.gooddata.util.Validate.notNull(schedule, "schedule");
        com.gooddata.util.Validate.notNull(project, "project");
        String uri = ProcessService.getScheduleUri(project, schedule.getId()).toString();
        try {
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.PUT, new HttpEntity((Object)schedule), Schedule.class, new Object[0]);
            if (response == null) {
                throw new GoodDataException("Unable to update schedule. No response returned from API.");
            }
            return (Schedule)response.getBody();
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ScheduleNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get schedule " + uri, e);
        }
    }

    public Schedule getScheduleByUri(String uri) {
        com.gooddata.util.Validate.notEmpty(uri, "uri");
        try {
            return (Schedule)this.restTemplate.getForObject(uri, Schedule.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ScheduleNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get schedule " + uri, e);
        }
    }

    public Schedule getScheduleById(Project project, String id) {
        com.gooddata.util.Validate.notEmpty(id, "id");
        com.gooddata.util.Validate.notNull(project, "project");
        return this.getScheduleByUri(ProcessService.getScheduleUri(project, id).toString());
    }

    public PageableList<Schedule> listSchedules(Project project) {
        com.gooddata.util.Validate.notNull(project, "project");
        return this.listSchedules(ProcessService.getSchedulesUri(project));
    }

    public PageableList<Schedule> listSchedules(Project project, Page page) {
        com.gooddata.util.Validate.notNull(project, "project");
        com.gooddata.util.Validate.notNull(page, "page");
        return this.listSchedules(page.getPageUri(UriComponentsBuilder.fromUri((URI)ProcessService.getSchedulesUri(project))));
    }

    public void removeSchedule(Schedule schedule) {
        com.gooddata.util.Validate.notNull(schedule, "schedule");
        try {
            this.restTemplate.delete(schedule.getUri(), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to remove schedule " + schedule.getUri(), e);
        }
    }

    private PageableList<Schedule> listSchedules(URI uri) {
        try {
            Schedules schedules = (Schedules)this.restTemplate.getForObject(uri, Schedules.class);
            if (schedules == null) {
                return new PageableList<Schedule>();
            }
            return schedules;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list schedules", e);
        }
    }

    private static URI getScheduleUri(Project project, String id) {
        return Schedule.TEMPLATE.expand(new Object[]{project.getId(), id});
    }

    private static URI getSchedulesUri(Project project) {
        return Schedules.TEMPLATE.expand(new Object[]{project.getId()});
    }

    private Schedule postSchedule(Schedule schedule, URI postUri) {
        try {
            return (Schedule)this.restTemplate.postForObject(postUri, (Object)schedule, Schedule.class);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to post schedule.", e);
        }
    }

    private Collection<DataloadProcess> listProcesses(URI uri) {
        try {
            DataloadProcesses processes = (DataloadProcesses)this.restTemplate.getForObject(uri, DataloadProcesses.class);
            if (processes == null) {
                throw new GoodDataException("empty response from API call");
            }
            if (processes.getItems() == null) {
                return Collections.emptyList();
            }
            return processes.getItems();
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list processes", e);
        }
    }

    private static URI getProcessUri(Project project, String id) {
        return DataloadProcess.TEMPLATE.expand(new Object[]{project.getId(), id});
    }

    private static URI getProcessesUri(Project project) {
        return DataloadProcesses.TEMPLATE.expand(new Object[]{project.getId()});
    }

    /*
     * Unable to fully structure code
     */
    private DataloadProcess postProcess(DataloadProcess process, File processData, URI postUri) {
        tempFile = this.createTempFile("process", ".zip");
        try {
            output = new FileOutputStream(tempFile);
            var6_7 = null;
            try {
                ZipHelper.zip(processData, output);
            }
            catch (Throwable var7_9) {
                var6_7 = var7_9;
                throw var7_9;
            }
            finally {
                if (output != null) {
                    if (var6_7 != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable var7_8) {
                            var6_7.addSuppressed(var7_8);
                        }
                    } else {
                        output.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new GoodDataException("Unable to zip process data", e);
        }
        method = HttpMethod.POST;
        if (tempFile.length() > 0x100000L) {
            try {
                process.setPath(this.dataStoreService.getUri(tempFile.getName()).getPath());
                this.dataStoreService.upload(tempFile.getName(), (InputStream)new FileInputStream(tempFile));
                processToSend = process;
                if (!DataloadProcess.TEMPLATE.matches(postUri.toString())) ** GOTO lbl42
                method = HttpMethod.PUT;
            }
            catch (FileNotFoundException e) {
                throw new GoodDataException("Unable to access zipped process data at " + tempFile.getAbsolutePath(), e);
            }
        } else {
            parts = new LinkedMultiValueMap(2);
            parts.add((Object)"process", (Object)process);
            headers = new HttpHeaders();
            headers.setContentType(ProcessService.MEDIA_TYPE_ZIP);
            parts.add((Object)"data", (Object)new HttpEntity((Object)new FileSystemResource(tempFile), (MultiValueMap)headers));
            processToSend = parts;
        }
lbl42:
        // 3 sources

        try {
            response = this.restTemplate.exchange(postUri, method, new HttpEntity((Object)processToSend), DataloadProcess.class);
            if (response == null) {
                throw new GoodDataException("Unable to post dataload process. No response returned from API.");
            }
            var8_14 = (DataloadProcess)response.getBody();
            return var8_14;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to post dataload process.", e);
        }
        finally {
            this.deleteTempFile(tempFile);
        }
    }

    private FutureResult<DataloadProcess> postProcess(DataloadProcess process, URI postUri, HttpMethod method) {
        try {
            ResponseEntity exchange = this.restTemplate.exchange(postUri, method, new HttpEntity((Object)process), String.class);
            if (exchange.getStatusCode() == HttpStatus.ACCEPTED) {
                AsyncTask asyncTask = (AsyncTask)this.mapper.readValue((String)exchange.getBody(), AsyncTask.class);
                return new PollResult<DataloadProcess>(this, new SimplePollHandler<DataloadProcess>(asyncTask.getUri(), DataloadProcess.class){

                    @Override
                    public void handlePollException(GoodDataRestException e) {
                        throw new GoodDataException("Creating process failed", e);
                    }
                });
            }
            if (exchange.getStatusCode() == HttpStatus.OK) {
                DataloadProcess dataloadProcess = (DataloadProcess)this.mapper.readValue((String)exchange.getBody(), DataloadProcess.class);
                return new PollResult<DataloadProcess>(this, new SimplePollHandler<DataloadProcess>(dataloadProcess.getUri(), DataloadProcess.class){

                    @Override
                    public void handlePollException(GoodDataRestException e) {
                        throw new GoodDataException("Creating process failed", e);
                    }
                });
            }
            throw new IllegalStateException("Unexpected status code from resource: " + exchange.getStatusCode());
        }
        catch (IOException | RestClientException e) {
            throw new GoodDataException("Creating process failed", e);
        }
    }

    private DataloadProcess postProcess(DataloadProcess process, URI postUri) {
        try {
            return (DataloadProcess)this.restTemplate.postForObject(postUri, (Object)process, DataloadProcess.class);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create dataload process.", e);
        }
    }

    private File createTempFile(String prefix, String suffix) {
        File tempFile;
        try {
            tempFile = File.createTempFile(prefix, suffix);
            tempFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new GoodDataException("Unable to create temporary file", e);
        }
        return tempFile;
    }

    private void deleteTempFile(File file) {
        com.gooddata.util.Validate.notNull(file, "file");
        file.delete();
    }
}

