/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.gdc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.util.Validate;
import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ErrorStructure {
    protected final String message;
    protected final Object[] parameters;
    protected final String component;
    protected final String errorClass;
    protected final String errorCode;
    protected final String errorId;
    protected final String trace;
    protected final String requestId;

    @JsonCreator
    protected ErrorStructure(@JsonProperty(value="errorClass") String errorClass, @JsonProperty(value="component") String component, @JsonProperty(value="parameters") Object[] parameters, @JsonProperty(value="message") String message, @JsonProperty(value="errorCode") String errorCode, @JsonProperty(value="errorId") String errorId, @JsonProperty(value="trace") String trace, @JsonProperty(value="requestId") String requestId) {
        this.errorClass = errorClass;
        this.component = component;
        this.parameters = parameters;
        this.message = Validate.notNull(message, "message");
        this.errorCode = errorCode;
        this.errorId = errorId;
        this.trace = trace;
        this.requestId = requestId;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getParameters() {
        return this.parameters == null ? null : Arrays.copyOf(this.parameters, this.parameters.length);
    }

    public String getComponent() {
        return this.component;
    }

    public String getErrorClass() {
        return this.errorClass;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public String getTrace() {
        return this.trace;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @JsonIgnore
    public String getFormattedMessage() {
        return this.message == null ? null : String.format(this.message, this.parameters);
    }

    public String toString() {
        return this.getFormattedMessage();
    }
}

