/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.PollHandler;
import com.gooddata.util.Validate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractService {
    public static final Integer WAIT_BEFORE_RETRY_IN_MILLIS = 5000;
    protected final RestTemplate restTemplate;
    protected final ObjectMapper mapper = new ObjectMapper();
    private final ResponseExtractor<ClientHttpResponse> reusableResponseExtractor = new ResponseExtractor<ClientHttpResponse>(){

        public ClientHttpResponse extractData(ClientHttpResponse response) throws IOException {
            return new ReusableClientHttpResponse(response);
        }
    };

    public AbstractService(RestTemplate restTemplate) {
        this.restTemplate = Validate.notNull(restTemplate, "restTemplate");
    }

    final <R> R poll(PollHandler<?, R> handler, long timeout, TimeUnit unit) {
        Validate.notNull(handler, "handler");
        long start = System.currentTimeMillis();
        while (!this.pollOnce(handler)) {
            if (unit != null && start + unit.toMillis(timeout) < System.currentTimeMillis()) {
                throw new GoodDataException("timeout");
            }
            try {
                Thread.sleep(WAIT_BEFORE_RETRY_IN_MILLIS.intValue());
            }
            catch (InterruptedException e) {
                throw new GoodDataException("interrupted");
            }
        }
        return handler.getResult();
    }

    final <P> boolean pollOnce(PollHandler<P, ?> handler) {
        ClientHttpResponse response;
        Validate.notNull(handler, "handler");
        try {
            response = (ClientHttpResponse)this.restTemplate.execute(handler.getPollingUri(), HttpMethod.GET, null, this.reusableResponseExtractor, new Object[0]);
        }
        catch (GoodDataRestException e) {
            handler.handlePollException(e);
            throw new GoodDataException("Handler " + handler.getClass().getName() + " didn't handle exception", e);
        }
        try {
            if (handler.isFinished(response)) {
                P data = this.extractData(response, handler.getPollClass());
                handler.handlePollResult(data);
            } else if (HttpStatus.Series.CLIENT_ERROR.equals((Object)response.getStatusCode().series())) {
                throw new GoodDataException(String.format("Polling returned client error HTTP status %s", response.getStatusCode().value()));
            }
        }
        catch (IOException e) {
            throw new GoodDataException("I/O error occurred during HTTP response extraction", e);
        }
        return handler.isDone();
    }

    protected final <T> T extractData(ClientHttpResponse response, Class<T> cls) throws IOException {
        Validate.notNull(response, "response");
        Validate.notNull(cls, "cls");
        if (Void.class.isAssignableFrom(cls)) {
            return null;
        }
        return (T)new HttpMessageConverterExtractor(cls, this.restTemplate.getMessageConverters()).extractData(response);
    }

    protected static class OutputStreamResponseExtractor
    implements ResponseExtractor<Integer> {
        private final OutputStream output;

        public OutputStreamResponseExtractor(OutputStream output) {
            this.output = output;
        }

        public Integer extractData(ClientHttpResponse response) throws IOException {
            return FileCopyUtils.copy((InputStream)response.getBody(), (OutputStream)this.output);
        }
    }

    private static class ReusableClientHttpResponse
    implements ClientHttpResponse {
        private byte[] body;
        private final HttpStatus statusCode;
        private final int rawStatusCode;
        private final String statusText;
        private final HttpHeaders headers;

        public ReusableClientHttpResponse(ClientHttpResponse response) {
            try {
                InputStream bodyStream = response.getBody();
                if (bodyStream != null) {
                    this.body = FileCopyUtils.copyToByteArray((InputStream)bodyStream);
                }
                this.statusCode = response.getStatusCode();
                this.rawStatusCode = response.getRawStatusCode();
                this.statusText = response.getStatusText();
                this.headers = response.getHeaders();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read from HTTP response", e);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }

        public HttpStatus getStatusCode() throws IOException {
            return this.statusCode;
        }

        public int getRawStatusCode() throws IOException {
            return this.rawStatusCode;
        }

        public String getStatusText() throws IOException {
            return this.statusText;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public InputStream getBody() throws IOException {
            return this.body != null ? new ByteArrayInputStream(this.body) : null;
        }

        public void close() {
        }
    }
}

