/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.connector;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.connector.ConnectorType;
import com.gooddata.connector.ProcessExecution;
import com.gooddata.util.ISODateTimeSerializer;
import com.gooddata.util.Validate;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;

public class Zendesk4ProcessExecution
implements ProcessExecution {
    private Boolean incremental;
    private Map<String, DateTime> startTimes;

    @Override
    public ConnectorType getConnectorType() {
        return ConnectorType.ZENDESK4;
    }

    public Boolean getIncremental() {
        return this.incremental;
    }

    public void setIncremental(Boolean incremental) {
        this.incremental = incremental;
    }

    @JsonAnyGetter
    @JsonSerialize(contentUsing=ISODateTimeSerializer.class)
    public Map<String, DateTime> getStartTimes() {
        return this.startTimes;
    }

    public void setStartTime(String resource, DateTime startTime) {
        Validate.notEmpty(resource, "resource can't be empty");
        Validate.notNull(startTime, "startTime can't be null");
        this.startTimes = this.startTimes == null ? new TreeMap() : this.startTimes;
        this.startTimes.put(resource + "StartDate", startTime);
    }
}

