/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataload.processes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.gdc.ErrorStructure;
import com.gooddata.util.ISODateTimeDeserializer;
import com.gooddata.util.ISODateTimeSerializer;
import com.gooddata.util.Validate;
import java.net.URI;
import java.util.Map;
import org.joda.time.DateTime;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="executionDetail")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProcessExecutionDetail {
    private static final String LOG_LINK = "log";
    private static final String SELF_LINK = "self";
    private static final String EXECUTION_LINK = "poll";
    private static final String STATUS_OK = "OK";
    private final String status;
    private final DateTime created;
    private final DateTime started;
    private final DateTime updated;
    private final DateTime finished;
    private final ErrorStructure error;
    private final Map<String, String> links;

    @JsonCreator
    private ProcessExecutionDetail(@JsonProperty(value="status") String status, @JsonProperty(value="created") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime created, @JsonProperty(value="started") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime started, @JsonProperty(value="updated") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime updated, @JsonProperty(value="finished") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime finished, @JsonProperty(value="error") ErrorStructure error, @JsonProperty(value="links") Map<String, String> links) {
        this.status = Validate.notEmpty(status, "status");
        this.created = Validate.notNull(created, "created");
        this.started = started;
        this.updated = updated;
        this.finished = finished;
        this.error = error;
        this.links = links;
    }

    public String getStatus() {
        return this.status;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class)
    public DateTime getCreated() {
        return this.created;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class)
    public DateTime getStarted() {
        return this.started;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class)
    public DateTime getUpdated() {
        return this.updated;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class)
    public DateTime getFinished() {
        return this.finished;
    }

    public ErrorStructure getError() {
        return this.error;
    }

    @Deprecated
    @JsonIgnore
    public String getLogLink() {
        return this.getLogUri();
    }

    @JsonIgnore
    public String getLogUri() {
        return this.links != null ? this.links.get(LOG_LINK) : null;
    }

    @JsonIgnore
    public String getUri() {
        return this.links != null ? this.links.get(SELF_LINK) : null;
    }

    @Deprecated
    @JsonIgnore
    public String getExecutionLink() {
        return this.getExecutionUri();
    }

    @JsonIgnore
    public String getExecutionUri() {
        return this.links != null ? this.links.get(EXECUTION_LINK) : null;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return STATUS_OK.equals(this.status);
    }

    public static URI uriFromExecutionUri(URI executionUri) {
        return URI.create(executionUri.toString() + "/detail");
    }
}

