/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gooddata.md.Meta;
import com.gooddata.project.Environment;
import com.gooddata.project.ProjectDriver;
import com.gooddata.project.ProjectEnvironment;
import com.gooddata.util.BooleanDeserializer;
import com.gooddata.util.GDDateTimeDeserializer;
import com.gooddata.util.Validate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.DateTime;
import org.springframework.web.util.UriTemplate;

@JsonTypeName(value="project")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Project {
    public static final String PROJECTS_URI = "/gdc/account/profile/{id}/projects";
    public static final String URI = "/gdc/projects/{id}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/projects/{id}");
    private static final Set<String> PREPARING_STATES = new HashSet<String>(Arrays.asList("PREPARING", "PREPARED", "LOADING"));
    @JsonProperty(value="content")
    private ProjectContent content;
    @JsonProperty(value="meta")
    private ProjectMeta meta;
    @JsonIgnore
    private Links links;

    public Project(String title, String authorizationToken) {
        this.content = new ProjectContent(authorizationToken);
        this.meta = new ProjectMeta(title);
    }

    public Project(String title, String summary, String authorizationToken) {
        this.content = new ProjectContent(authorizationToken);
        this.meta = new ProjectMeta(title, summary);
    }

    @JsonCreator
    private Project(@JsonProperty(value="content") ProjectContent content, @JsonProperty(value="meta") ProjectMeta meta, @JsonProperty(value="links") Links links) {
        this.content = content;
        this.meta = meta;
        this.links = links;
    }

    public void setProjectTemplate(String uri) {
        this.meta.setProjectTemplate(uri);
    }

    @JsonIgnore
    public String getId() {
        return (String)TEMPLATE.match(this.getUri()).get("id");
    }

    @JsonIgnore
    public String getState() {
        return this.content.getState();
    }

    @JsonIgnore
    public String getAuthorizationToken() {
        return this.content.getAuthorizationToken();
    }

    @JsonIgnore
    public String getDriver() {
        return this.content.getDriver();
    }

    @JsonIgnore
    public String getGuidedNavigation() {
        return this.content.getGuidedNavigation();
    }

    @JsonIgnore
    public String getCluster() {
        return this.content.getCluster();
    }

    @JsonIgnore
    public Boolean isPublic() {
        return "1".equals(this.content.getIsPublic());
    }

    @JsonIgnore
    public String getTitle() {
        return this.meta.getTitle();
    }

    @JsonIgnore
    public String getSummary() {
        return this.meta.getSummary();
    }

    @JsonIgnore
    public String getAuthor() {
        return this.meta.getAuthor();
    }

    @JsonIgnore
    public String getContributor() {
        return this.meta.getContributor();
    }

    @JsonIgnore
    public DateTime getCreated() {
        return this.meta.getCreated();
    }

    @JsonIgnore
    public DateTime getUpdated() {
        return this.meta.getUpdated();
    }

    @JsonIgnore
    public String getUri() {
        return this.links.getSelf();
    }

    @Deprecated
    @JsonIgnore
    public String getUsersLink() {
        return this.getUsersUri();
    }

    @JsonIgnore
    public String getUsersUri() {
        return this.links.getUsers();
    }

    @Deprecated
    @JsonIgnore
    public String getRolesLink() {
        return this.getRolesUri();
    }

    @JsonIgnore
    public String getRolesUri() {
        return this.links.getRoles();
    }

    @Deprecated
    @JsonIgnore
    public String getGroupsLink() {
        return this.getGroupsUri();
    }

    @JsonIgnore
    public String getGroupsUri() {
        return this.links.getGroups();
    }

    @Deprecated
    @JsonIgnore
    public String getInvitationsLink() {
        return this.getInvitationsUri();
    }

    @JsonIgnore
    public String getInvitationsUri() {
        return this.links.getInvitations();
    }

    @Deprecated
    @JsonIgnore
    public String getLdmLink() {
        return this.getLdmUri();
    }

    @JsonIgnore
    public String getLdmUri() {
        return this.links.getLdm();
    }

    @Deprecated
    @JsonIgnore
    public String getLdmThumbnailLink() {
        return this.getLdmThumbnailUri();
    }

    @JsonIgnore
    public String getLdmThumbnailUri() {
        return this.links.getLdmThumbnail();
    }

    @Deprecated
    @JsonIgnore
    public String getMetadataLink() {
        return this.getMetadataUri();
    }

    @JsonIgnore
    public String getMetadataUri() {
        return this.links.getMetadata();
    }

    @Deprecated
    @JsonIgnore
    public String getPublicArtifactsLink() {
        return this.getPublicArtifactsUri();
    }

    @JsonIgnore
    public String getPublicArtifactsUri() {
        return this.links.getPublicArtifacts();
    }

    @Deprecated
    @JsonIgnore
    public String getTemplatesLink() {
        return this.getTemplatesUri();
    }

    @JsonIgnore
    public String getTemplatesUri() {
        return this.links.getTemplates();
    }

    @Deprecated
    @JsonIgnore
    public String getConnectorsLink() {
        return this.getConnectorsUri();
    }

    @JsonIgnore
    public String getConnectorsUri() {
        return this.links.getConnectors();
    }

    @Deprecated
    @JsonIgnore
    public String getDataLoadLink() {
        return this.getDataLoadUri();
    }

    @JsonIgnore
    public String getDataLoadUri() {
        return this.links.getDataLoad();
    }

    @Deprecated
    @JsonIgnore
    public String getSchedulesLink() {
        return this.getSchedulesUri();
    }

    @JsonIgnore
    public String getSchedulesUri() {
        return this.links.getSchedules();
    }

    @Deprecated
    @JsonIgnore
    public String getExecuteLink() {
        return this.getExecuteUri();
    }

    @JsonIgnore
    public String getExecuteUri() {
        return this.links.getExecute();
    }

    @Deprecated
    @JsonIgnore
    public String getEventStoresLink() {
        return this.getEventStoresUri();
    }

    @JsonIgnore
    public String getEventStoresUri() {
        return this.links.getEventStores();
    }

    @Deprecated
    @JsonIgnore
    public String getClearCachesLink() {
        return this.getClearCachesUri();
    }

    @JsonIgnore
    public String getClearCachesUri() {
        return this.links.getClearCaches();
    }

    @Deprecated
    @JsonIgnore
    public String getUploadsLink() {
        return this.getUploadsUri();
    }

    @JsonIgnore
    public String getUploadsUri() {
        return this.links.getUploads();
    }

    @JsonIgnore
    public boolean isPreparing() {
        return PREPARING_STATES.contains(this.getState());
    }

    @JsonIgnore
    public boolean isEnabled() {
        return "ENABLED".equals(this.getState());
    }

    public void setDriver(String driver) {
        Validate.notEmpty(driver, "driver cannot be empty!");
        this.content.setDriver(driver);
    }

    public void setDriver(ProjectDriver driver) {
        Validate.notNull(driver, "driver cannot be null!");
        this.setDriver(driver.getValue());
    }

    @JsonIgnore
    public String getEnvironment() {
        return this.content.getEnvironment();
    }

    @JsonIgnore
    public void setEnvironment(String environment) {
        this.content.setEnvironment(environment);
    }

    public void setEnvironment(ProjectEnvironment environment) {
        Validate.notNull(environment, "environment");
        this.setEnvironment(environment.name());
    }

    public void setEnvironment(Environment environment) {
        Validate.notNull(environment, "environment");
        this.setEnvironment(environment.name());
    }

    private static class ProjectMeta
    extends Meta {
        private String projectTemplate;

        @JsonCreator
        private ProjectMeta(@JsonProperty(value="author") String author, @JsonProperty(value="contributor") String contributor, @JsonProperty(value="created") @JsonDeserialize(using=GDDateTimeDeserializer.class) DateTime created, @JsonProperty(value="updated") @JsonDeserialize(using=GDDateTimeDeserializer.class) DateTime updated, @JsonProperty(value="summary") String summary, @JsonProperty(value="title") String title, @JsonProperty(value="category") String category, @JsonProperty(value="tags") Set<String> tags, @JsonProperty(value="uri") String uri, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="deprecated") @JsonDeserialize(using=BooleanDeserializer.class) Boolean deprecated, @JsonProperty(value="isProduction") @JsonDeserialize(using=BooleanDeserializer.class) Boolean production, @JsonProperty(value="locked") @JsonDeserialize(using=BooleanDeserializer.class) Boolean locked, @JsonProperty(value="unlisted") @JsonDeserialize(using=BooleanDeserializer.class) Boolean unlisted, @JsonProperty(value="sharedWithSomeone") @JsonDeserialize(using=BooleanDeserializer.class) Boolean sharedWithSomeone) {
            super(author, contributor, created, updated, summary, title, category, tags, uri, identifier, deprecated, production, locked, unlisted, sharedWithSomeone);
        }

        private ProjectMeta(String title) {
            super(title);
        }

        private ProjectMeta(String title, String summary) {
            super(title, summary);
        }

        public String getProjectTemplate() {
            return this.projectTemplate;
        }

        public void setProjectTemplate(String projectTemplate) {
            this.projectTemplate = projectTemplate;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Links {
        private final String self;
        private final String users;
        private final String roles;
        private final String groups;
        private final String invitations;
        private final String ldm;
        private final String ldmThumbnail;
        private final String metadata;
        private final String publicArtifacts;
        private final String templates;
        private final String connectors;
        private final String dataLoad;
        private final String schedules;
        private final String execute;
        private final String eventStores;
        private final String clearCaches;
        private final String uploads;

        @JsonCreator
        public Links(@JsonProperty(value="self") String self, @JsonProperty(value="users") String users, @JsonProperty(value="roles") String roles, @JsonProperty(value="groups") String groups, @JsonProperty(value="invitations") String invitations, @JsonProperty(value="ldm") String ldm, @JsonProperty(value="ldm_thumbnail") String ldmThumbnail, @JsonProperty(value="metadata") String metadata, @JsonProperty(value="publicartifacts") String publicArtifacts, @JsonProperty(value="templates") String templates, @JsonProperty(value="connectors") String connectors, @JsonProperty(value="dataload") String dataLoad, @JsonProperty(value="schedules") String schedules, @JsonProperty(value="execute") String execute, @JsonProperty(value="eventstores") String eventStores, @JsonProperty(value="clearCaches") String clearCaches, @JsonProperty(value="uploads") String uploads) {
            this.self = self;
            this.users = users;
            this.roles = roles;
            this.groups = groups;
            this.invitations = invitations;
            this.ldm = ldm;
            this.ldmThumbnail = ldmThumbnail;
            this.metadata = metadata;
            this.publicArtifacts = publicArtifacts;
            this.templates = templates;
            this.connectors = connectors;
            this.dataLoad = dataLoad;
            this.schedules = schedules;
            this.execute = execute;
            this.eventStores = eventStores;
            this.clearCaches = clearCaches;
            this.uploads = uploads;
        }

        public String getSelf() {
            return this.self;
        }

        public String getUsers() {
            return this.users;
        }

        public String getRoles() {
            return this.roles;
        }

        public String getGroups() {
            return this.groups;
        }

        public String getInvitations() {
            return this.invitations;
        }

        public String getLdm() {
            return this.ldm;
        }

        public String getLdmThumbnail() {
            return this.ldmThumbnail;
        }

        public String getMetadata() {
            return this.metadata;
        }

        public String getPublicArtifacts() {
            return this.publicArtifacts;
        }

        public String getTemplates() {
            return this.templates;
        }

        public String getConnectors() {
            return this.connectors;
        }

        public String getDataLoad() {
            return this.dataLoad;
        }

        public String getSchedules() {
            return this.schedules;
        }

        public String getExecute() {
            return this.execute;
        }

        public String getEventStores() {
            return this.eventStores;
        }

        public String getClearCaches() {
            return this.clearCaches;
        }

        public String getUploads() {
            return this.uploads;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class ProjectContent {
        @JsonProperty(value="authorizationToken")
        private String authorizationToken;
        @JsonProperty(value="driver")
        private String driver;
        @JsonProperty(value="guidedNavigation")
        private String guidedNavigation;
        @JsonIgnore
        private String cluster;
        @JsonIgnore
        private String isPublic;
        @JsonIgnore
        private String state;
        @JsonProperty
        private String environment;

        public ProjectContent(String authorizationToken) {
            this.authorizationToken = authorizationToken;
            this.guidedNavigation = "1";
            this.driver = ProjectDriver.POSTGRES.getValue();
        }

        @JsonCreator
        public ProjectContent(@JsonProperty(value="authorizationToken") String authorizationToken, @JsonProperty(value="driver") String driver, @JsonProperty(value="cluster") String cluster, @JsonProperty(value="guidedNavigation") String guidedNavigation, @JsonProperty(value="isPublic") String isPublic, @JsonProperty(value="environment") String environment, @JsonProperty(value="state") String state) {
            this.authorizationToken = authorizationToken;
            this.guidedNavigation = guidedNavigation;
            this.driver = driver;
            this.cluster = cluster;
            this.isPublic = isPublic;
            this.state = state;
            this.environment = environment;
        }

        public String getState() {
            return this.state;
        }

        public String getAuthorizationToken() {
            return this.authorizationToken;
        }

        public String getDriver() {
            return this.driver;
        }

        public String getGuidedNavigation() {
            return this.guidedNavigation;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getIsPublic() {
            return this.isPublic;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public void setEnvironment(String environment) {
            this.environment = environment;
        }
    }
}

