/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.gdc;

import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineException;
import com.gooddata.UriPrefixer;
import com.gooddata.gdc.DataStoreException;
import com.gooddata.gdc.GdcSardine;
import com.gooddata.gdc.GdcService;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class DataStoreService {
    private final Sardine sardine;
    private final GdcService gdcService;
    private final URI gdcUri;
    private final RestTemplate restTemplate;
    private UriPrefixer prefixer;

    public DataStoreService(HttpClient httpClient, RestTemplate restTemplate, GdcService gdcService, String gdcUri) {
        this.gdcService = Validate.notNull(gdcService, "gdcService");
        this.gdcUri = URI.create(Validate.notEmpty(gdcUri, "gdcUri"));
        this.restTemplate = Validate.notNull(restTemplate, "restTemplate");
        this.sardine = new GdcSardine(new CustomHttpClientBuilder(httpClient));
    }

    private UriPrefixer getPrefixer() {
        if (this.prefixer == null) {
            String uriString = this.gdcService.getRootLinks().getUserStagingUri();
            URI uri = URI.create(uriString);
            this.prefixer = new UriPrefixer(uri.isAbsolute() ? uri : this.gdcUri.resolve(uriString));
            this.sardine.enablePreemptiveAuthentication(this.prefixer.getUriPrefix().getHost());
        }
        return this.prefixer;
    }

    public URI getUri(String path) {
        return this.getPrefixer().mergeUris(path);
    }

    public void upload(String path, InputStream stream) {
        Validate.notEmpty(path, "path");
        Validate.notNull(stream, "stream");
        this.upload(this.getUri(path), stream);
    }

    private void upload(URI url, InputStream stream) {
        try {
            this.sardine.put(url.toString(), stream);
        }
        catch (SardineException e) {
            if (HttpStatus.INTERNAL_SERVER_ERROR.value() == e.getStatusCode()) {
                throw new DataStoreException(this.createUnAuthRequestWarningMessage(url), e);
            }
            throw new DataStoreException("Unable to upload to " + url + " got status " + e.getStatusCode(), e);
        }
        catch (NoHttpResponseException e) {
            throw new DataStoreException(this.createUnAuthRequestWarningMessage(url), e);
        }
        catch (IOException e) {
            if (e.getCause() instanceof NonRepeatableRequestException) {
                throw new DataStoreException(this.createUnAuthRequestWarningMessage(url), e);
            }
            throw new DataStoreException("Unable to upload to " + url, e);
        }
    }

    private String createUnAuthRequestWarningMessage(URI url) {
        return "Got 500 while uploading to " + url + ".\nThis can be known limitation, see https://github.com/gooddata/gooddata-java/wiki/Known-limitations";
    }

    public InputStream download(String path) {
        Validate.notEmpty(path, "path");
        URI uri = this.getUri(path);
        try {
            return this.sardine.get(uri.toString());
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to download from " + uri, e);
        }
    }

    public void delete(String path) {
        Validate.notEmpty(path, "path");
        URI uri = this.getUri(path);
        try {
            ResponseEntity result = this.restTemplate.exchange(uri, HttpMethod.DELETE, org.springframework.http.HttpEntity.EMPTY, Void.class);
            if (HttpStatus.MOVED_PERMANENTLY.equals((Object)result.getStatusCode())) {
                this.restTemplate.exchange(result.getHeaders().getLocation(), HttpMethod.DELETE, org.springframework.http.HttpEntity.EMPTY, Void.class);
            }
        }
        catch (RestClientException e) {
            throw new DataStoreException("Unable to delete " + uri, e);
        }
    }

    private static class FakeCloseableHttpResponse
    implements CloseableHttpResponse {
        private final HttpResponse wrappedResponse;

        public FakeCloseableHttpResponse(HttpResponse wrappedResponse) {
            Validate.notNull(wrappedResponse, "wrappedResponse");
            this.wrappedResponse = wrappedResponse;
        }

        public void close() throws IOException {
        }

        public StatusLine getStatusLine() {
            return this.wrappedResponse.getStatusLine();
        }

        public void setStatusLine(StatusLine statusline) {
            this.wrappedResponse.setStatusLine(statusline);
        }

        public void setStatusLine(ProtocolVersion ver, int code) {
            this.wrappedResponse.setStatusLine(ver, code);
        }

        public void setStatusLine(ProtocolVersion ver, int code, String reason) {
            this.wrappedResponse.setStatusLine(ver, code, reason);
        }

        public void setStatusCode(int code) throws IllegalStateException {
            this.wrappedResponse.setStatusCode(code);
        }

        public void setReasonPhrase(String reason) throws IllegalStateException {
            this.wrappedResponse.setReasonPhrase(reason);
        }

        public HttpEntity getEntity() {
            return this.wrappedResponse.getEntity();
        }

        public void setEntity(HttpEntity entity) {
            this.wrappedResponse.setEntity(entity);
        }

        public Locale getLocale() {
            return this.wrappedResponse.getLocale();
        }

        public void setLocale(Locale loc) {
            this.wrappedResponse.setLocale(loc);
        }

        public ProtocolVersion getProtocolVersion() {
            return this.wrappedResponse.getProtocolVersion();
        }

        public boolean containsHeader(String name) {
            return this.wrappedResponse.containsHeader(name);
        }

        public Header[] getHeaders(String name) {
            return this.wrappedResponse.getHeaders(name);
        }

        public Header getFirstHeader(String name) {
            return this.wrappedResponse.getFirstHeader(name);
        }

        public Header getLastHeader(String name) {
            return this.wrappedResponse.getLastHeader(name);
        }

        public Header[] getAllHeaders() {
            return this.wrappedResponse.getAllHeaders();
        }

        public void addHeader(Header header) {
            this.wrappedResponse.addHeader(header);
        }

        public void addHeader(String name, String value) {
            this.wrappedResponse.addHeader(name, value);
        }

        public void setHeader(Header header) {
            this.wrappedResponse.setHeader(header);
        }

        public void setHeader(String name, String value) {
            this.wrappedResponse.setHeader(name, value);
        }

        public void setHeaders(Header[] headers) {
            this.wrappedResponse.setHeaders(headers);
        }

        public void removeHeader(Header header) {
            this.wrappedResponse.removeHeader(header);
        }

        public void removeHeaders(String name) {
            this.wrappedResponse.removeHeaders(name);
        }

        public HeaderIterator headerIterator() {
            return this.wrappedResponse.headerIterator();
        }

        public HeaderIterator headerIterator(String name) {
            return this.wrappedResponse.headerIterator(name);
        }

        public HttpParams getParams() {
            return this.wrappedResponse.getParams();
        }

        public void setParams(HttpParams params) {
            this.wrappedResponse.setParams(params);
        }
    }

    private static class FakeCloseableHttpClient
    extends CloseableHttpClient {
        private final HttpClient client;

        private FakeCloseableHttpClient(HttpClient client) {
            Validate.notNull(client, "client");
            this.client = client;
        }

        protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return null;
        }

        public void close() throws IOException {
        }

        @Deprecated
        public HttpParams getParams() {
            return this.client.getParams();
        }

        @Deprecated
        public ClientConnectionManager getConnectionManager() {
            return this.client.getConnectionManager();
        }

        public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
            return new FakeCloseableHttpResponse(this.client.execute(request));
        }

        public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return new FakeCloseableHttpResponse(this.client.execute(request, context));
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
            return new FakeCloseableHttpResponse(this.client.execute(target, request));
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return new FakeCloseableHttpResponse(this.client.execute(target, request, context));
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            return (T)this.client.execute(request, responseHandler);
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            return (T)this.client.execute(request, responseHandler, context);
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            return (T)this.client.execute(target, request, responseHandler);
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            return (T)this.client.execute(target, request, responseHandler, context);
        }
    }

    private static class CustomHttpClientBuilder
    extends HttpClientBuilder {
        private final HttpClient client;

        private CustomHttpClientBuilder(HttpClient client) {
            this.client = client;
        }

        public CloseableHttpClient build() {
            return new FakeCloseableHttpClient(this.client);
        }
    }
}

