/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.collections;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gooddata.collections.PageableList;
import com.gooddata.util.Validate;
import java.io.IOException;

public abstract class PageableListSerializer
extends JsonSerializer<PageableList<?>> {
    private final String rootNode;

    public PageableListSerializer(String rootNode) {
        this.rootNode = Validate.notEmpty(rootNode, "rootNode");
    }

    public void serialize(PageableList<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeFieldName(this.rootNode);
        jgen.writeStartObject();
        jgen.writeFieldName("items");
        jgen.writeStartArray();
        ObjectCodec codec = jgen.getCodec();
        for (Object item : value.subList(0, value.size())) {
            codec.writeValue(jgen, item);
        }
        jgen.writeEndArray();
        this.writeObjectOrEmpty(jgen, codec, "paging", value.getPaging());
        this.writeObjectOrEmpty(jgen, codec, "links", value.getLinks());
        jgen.writeEndObject();
        jgen.writeEndObject();
    }

    public void serializeWithType(PageableList<?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, provider);
    }

    private void writeObjectOrEmpty(JsonGenerator jgen, ObjectCodec codec, String name, Object object) throws IOException {
        jgen.writeFieldName(name);
        if (object != null) {
            codec.writeValue(jgen, object);
        } else {
            jgen.writeStartObject();
            jgen.writeEndObject();
        }
    }
}

