/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.util;

import java.util.Collection;
import java.util.Iterator;

public abstract class Validate {
    public static <T> T notNull(T value, String argumentName) {
        if (value == null) {
            throw new IllegalArgumentException(argumentName + " can't be null");
        }
        return value;
    }

    public static <T extends CharSequence> T notEmpty(T value, String argumentName) {
        Validate.notNull(value, argumentName);
        if (value.toString().trim().length() == 0) {
            throw new IllegalArgumentException(argumentName + " can't be empty");
        }
        return value;
    }

    public static <T extends Collection> T notEmpty(T value, String argumentName) {
        Validate.notNull(value, argumentName);
        if (value.size() == 0) {
            throw new IllegalArgumentException(argumentName + " can't be empty");
        }
        return value;
    }

    public static <T extends Collection> T noNullElements(T collection, String argumentName) {
        Validate.notNull(collection, argumentName);
        int i = 0;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                throw new IllegalArgumentException(argumentName + " contains null element at index: " + i);
            }
            ++i;
        }
        return collection;
    }

    public static <T> T[] noNullElements(T[] array, String argument) {
        Validate.notNull(array, argument);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException(argument + " contains null element at index: " + i);
        }
        return array;
    }

    public static <T> T notNullState(T value, String argumentName) {
        if (value == null) {
            throw new IllegalStateException(argumentName + " is null");
        }
        return value;
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

