/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.warehouse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.ISODateTimeDeserializer;
import com.gooddata.util.ISODateTimeSerializer;
import com.gooddata.util.Validate;
import java.util.Map;
import org.joda.time.DateTime;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="s3Credentials")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WarehouseS3Credentials {
    public static final String URI = "/gdc/datawarehouse/instances/{id}/s3/{region}/{accessKey}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/datawarehouse/instances/{id}/s3/{region}/{accessKey}");
    private static final String SELF_LINK = "self";
    private final String region;
    private final String accessKey;
    private final DateTime updated;
    private final String updatedBy;
    private final String secretKey;
    private final Map<String, String> links;

    public WarehouseS3Credentials(String region, String accessKey, String secretKey) {
        this(region, accessKey, secretKey, null, null, null);
    }

    public WarehouseS3Credentials(String region, String accessKey, String updatedBy, DateTime updated) {
        this(region, accessKey, null, updatedBy, updated, null);
    }

    @JsonCreator
    WarehouseS3Credentials(@JsonProperty(value="region") String region, @JsonProperty(value="accessKey") String accessKey, @JsonProperty(value="secretKey") String secretKey, @JsonProperty(value="updatedBy") String updatedBy, @JsonProperty(value="updated") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime updated, @JsonProperty(value="links") Map<String, String> links) {
        this.region = region;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.updatedBy = updatedBy;
        this.updated = updated;
        this.links = links;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class)
    public DateTime getUpdated() {
        return this.updated;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getRegion() {
        return this.region;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    public WarehouseS3Credentials withLinks(Map<String, String> links) {
        return new WarehouseS3Credentials(this.region, this.accessKey, this.secretKey, this.updatedBy, this.updated, links);
    }

    @JsonIgnore
    public String getUri() {
        return Validate.notNullState(this.links, "links").get(SELF_LINK);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, "secretKey");
    }
}

