/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.warehouse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.ISODateTimeDeserializer;
import com.gooddata.util.ISODateTimeSerializer;
import com.gooddata.util.Validate;
import org.joda.time.DateTime;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="s3Credentials")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WarehouseS3Credentials {
    public static final String URI = "/gdc/datawarehouse/instances/{id}/s3/{region}/{accessKey}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/datawarehouse/instances/{id}/s3/{region}/{accessKey}");
    @JsonView(value={UpdateView.class})
    private final String region;
    @JsonView(value={UpdateView.class})
    private final String accessKey;
    private final DateTime updated;
    @JsonView(value={UpdateView.class})
    private String secretKey;
    private final Links links;

    public WarehouseS3Credentials(String region, String accessKey, String secretKey) {
        this(region, accessKey, secretKey, null, null);
    }

    @JsonCreator
    protected WarehouseS3Credentials(@JsonProperty(value="region") String region, @JsonProperty(value="accessKey") String accessKey, @JsonProperty(value="secretKey") String secretKey, @JsonProperty(value="updated") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime updated, @JsonProperty(value="links") Links links) {
        this.region = region;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.updated = updated;
        this.links = links;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class)
    public DateTime getUpdated() {
        return this.updated;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getRegion() {
        return this.region;
    }

    public Links getLinks() {
        return this.links;
    }

    @JsonIgnore
    public String getUri() {
        return Validate.notNullState(this.links, "links").getSelf();
    }

    @JsonIgnore
    public String getListUri() {
        return Validate.notNullState(this.links, "links").getParent();
    }

    @JsonIgnore
    public String getInstanceUri() {
        return Validate.notNullState(this.links, "links").getInstance();
    }

    @JsonIgnore
    public String getUpdatedByUri() {
        return Validate.notNullState(this.links, "links").getUpdatedBy();
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, "secretKey");
    }

    static class UpdateView {
        UpdateView() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Links {
        private final String self;
        private final String parent;
        private final String instance;
        private final String updatedBy;

        @JsonCreator
        public Links(@JsonProperty(value="self") String self, @JsonProperty(value="parent") String parent, @JsonProperty(value="instance") String instance, @JsonProperty(value="updatedBy") String updatedBy) {
            this.self = self;
            this.parent = parent;
            this.instance = instance;
            this.updatedBy = updatedBy;
        }

        public String getSelf() {
            return this.self;
        }

        public String getParent() {
            return this.parent;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getUpdatedBy() {
            return this.updatedBy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links links = (Links)o;
            return this.toString().equals(links.toString());
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString(this, new String[0]);
        }
    }
}

