/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonView;
import com.gooddata.util.GoodDataToStringBuilder;
import java.util.List;
import org.springframework.web.util.UriTemplate;

@JsonTypeName(value="accountSetting")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Account {
    public static final String URI = "/gdc/account/profile/{id}";
    public static final String ACCOUNTS_URI = "/gdc/account/domains/{organization_name}/users";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/account/profile/{id}");
    public static final UriTemplate ACCOUNTS_TEMPLATE = new UriTemplate("/gdc/account/domains/{organization_name}/users");
    public static final String LOGIN_URI = "/gdc/account/login/{id}";
    public static final UriTemplate LOGIN_TEMPLATE = new UriTemplate("/gdc/account/login/{id}");
    public static final String CURRENT_ID = "current";
    private final String login;
    @JsonView(value={UpdateView.class})
    private String email;
    @JsonView(value={UpdateView.class})
    private String password;
    @JsonView(value={UpdateView.class})
    private String verifyPassword;
    @JsonView(value={UpdateView.class})
    private String firstName;
    @JsonView(value={UpdateView.class})
    private String lastName;
    @JsonView(value={UpdateView.class})
    private List<String> ipWhitelist;
    @JsonIgnore
    private final Links links;

    @JsonCreator
    private Account(@JsonProperty(value="login") String login, @JsonProperty(value="email") String email, @JsonProperty(value="password") String password, @JsonProperty(value="verifyPassword") String verifyPassword, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="ipWhitelist") List<String> ipWhitelist, @JsonProperty(value="links") Links links) {
        this.login = login;
        this.email = email;
        this.password = password;
        this.verifyPassword = verifyPassword;
        this.firstName = firstName;
        this.lastName = lastName;
        this.ipWhitelist = ipWhitelist;
        this.links = links;
    }

    public Account(String firstName, String lastName, Links links) {
        this(null, null, null, null, firstName, lastName, null, links);
    }

    public Account(String email, String password, String firstName, String lastName) {
        this(email, email, password, password, firstName, lastName, null, null);
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public String getVerifyPassword() {
        return this.verifyPassword;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    @JsonIgnore
    public String getUri() {
        return this.links.getSelf();
    }

    @Deprecated
    @JsonIgnore
    public String getProjectsLink() {
        return this.getProjectsUri();
    }

    @JsonIgnore
    public String getProjectsUri() {
        return this.links.getProjects();
    }

    @JsonIgnore
    public String getId() {
        return Account.getId(this.getUri());
    }

    public List<String> getIpWhitelist() {
        return this.ipWhitelist;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setVerifyPassword(String verifyPassword) {
        this.verifyPassword = verifyPassword;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setIpWhitelist(List<String> ipWhitelist) {
        this.ipWhitelist = ipWhitelist;
    }

    static String getId(String uri) {
        return (String)TEMPLATE.match(uri).get("id");
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, "password", "verifyPassword");
    }

    static class UpdateView {
        UpdateView() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Links {
        private final String self;
        private final String projects;

        @JsonCreator
        public Links(@JsonProperty(value="self") String self, @JsonProperty(value="projects") String projects) {
            this.self = self;
            this.projects = projects;
        }

        public String getSelf() {
            return this.self;
        }

        public String getProjects() {
            return this.projects;
        }
    }
}

