/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Objects;

@JsonTypeName(value="coupaInstance")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CoupaInstance {
    private final String name;
    private final String apiUrl;
    private final String apiKey;

    @JsonCreator
    public CoupaInstance(@JsonProperty(value="name") String name, @JsonProperty(value="apiUrl") String apiUrl, @JsonProperty(value="apiKey") String apiKey) {
        Validate.notEmpty((CharSequence)name, (String)"name");
        Validate.notEmpty((CharSequence)apiUrl, (String)"apiUrl");
        this.name = name;
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
    }

    public String getName() {
        return this.name;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CoupaInstance)) {
            return false;
        }
        CoupaInstance that = (CoupaInstance)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.apiUrl, that.apiUrl) && Objects.equals(this.apiKey, that.apiKey);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.apiUrl, this.apiKey);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }
}

