/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.featureflag;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.featureflag.ProjectFeatureFlag;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="featureFlags")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectFeatureFlags
implements Iterable<ProjectFeatureFlag> {
    public static final String PROJECT_FEATURE_FLAGS_URI = "/gdc/projects/{id}/projectFeatureFlags";
    public static final UriTemplate PROJECT_FEATURE_FLAGS_TEMPLATE = new UriTemplate("/gdc/projects/{id}/projectFeatureFlags");
    @JsonProperty(value="items")
    private final List<ProjectFeatureFlag> items = new LinkedList<ProjectFeatureFlag>();

    @JsonCreator
    ProjectFeatureFlags(@JsonProperty(value="items") List<ProjectFeatureFlag> items) {
        if (!CollectionUtils.isEmpty(items)) {
            this.items.addAll(items);
        }
    }

    @Override
    public Iterator<ProjectFeatureFlag> iterator() {
        return this.items.iterator();
    }

    public boolean isEnabled(String flagName) {
        Validate.notEmpty((CharSequence)flagName, (String)"flagName");
        for (ProjectFeatureFlag flag : this.items) {
            if (!flagName.equalsIgnoreCase(flag.getName())) continue;
            return flag.isEnabled();
        }
        return false;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }
}

