/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.warehouse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.account.Account;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import com.gooddata.warehouse.WarehouseUserRole;
import java.util.Map;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="user")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WarehouseUser {
    public static final String URI = "/gdc/datawarehouse/instances/{id}/users/{userId}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/datawarehouse/instances/{id}/users/{userId}");
    @Deprecated
    public static final String ADMIN_ROLE = WarehouseUserRole.ADMIN.getRoleName();
    @Deprecated
    public static final String DATA_ADMIN_ROLE = WarehouseUserRole.DATA_ADMIN.getRoleName();
    @Deprecated
    public static final String READ_ONLY_ROLE = WarehouseUserRole.READ_ONLY.getRoleName();
    private static final String SELF_LINK = "self";
    private final String role;
    private final String profile;
    private final String login;
    private Map<String, String> links;

    public WarehouseUser(String role, String profile, String login) {
        this.role = (String)Validate.notNull((Object)role, (String)"role");
        if (profile == null) {
            Validate.notNull((Object)login, (String)"login");
        }
        if (login == null) {
            Validate.notNull((Object)profile, (String)"profile");
        }
        this.profile = profile;
        this.login = login;
    }

    public static WarehouseUser createWithProfileUri(String profileUri, WarehouseUserRole role) {
        Validate.notNull((Object)((Object)role), (String)"role cannot be null");
        return new WarehouseUser(role.getRoleName(), profileUri, null);
    }

    public static WarehouseUser createWithProfile(Account profile, WarehouseUserRole role) {
        Validate.notNull((Object)((Object)role), (String)"role cannot be null");
        Validate.notNull((Object)profile, (String)"profile cannot be null");
        return new WarehouseUser(role.getRoleName(), profile.getId(), null);
    }

    public static WarehouseUser createWithlogin(String login, WarehouseUserRole role) {
        Validate.notNull((Object)((Object)role), (String)"role cannot be null");
        return new WarehouseUser(role.getRoleName(), null, login);
    }

    @JsonCreator
    public WarehouseUser(@JsonProperty(value="role") String role, @JsonProperty(value="profile") String profile, @JsonProperty(value="login") String login, @JsonProperty(value="links") Map<String, String> links) {
        this(role, profile, login);
        this.links = links;
    }

    public String getRole() {
        return this.role;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getLogin() {
        return this.login;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public String getId() {
        return (String)TEMPLATE.match(this.getUri()).get("userId");
    }

    @JsonIgnore
    public String getUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(SELF_LINK);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }
}

