/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.auditevent;

import com.gooddata.AbstractService;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.GoodDataSettings;
import com.gooddata.account.Account;
import com.gooddata.account.AccountService;
import com.gooddata.auditevent.AuditEvent;
import com.gooddata.auditevent.AuditEventPageRequest;
import com.gooddata.auditevent.AuditEvents;
import com.gooddata.auditevent.AuditEventsForbiddenException;
import com.gooddata.collections.MultiPageList;
import com.gooddata.collections.Page;
import com.gooddata.collections.PageableList;
import com.gooddata.util.Validate;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class AuditEventService
extends AbstractService {
    private final AccountService accountService;

    public AuditEventService(RestTemplate restTemplate, AccountService accountService, GoodDataSettings settings) {
        super(restTemplate, settings);
        this.accountService = (AccountService)Validate.notNull((Object)accountService, (String)"account service");
    }

    @Deprecated
    public AuditEventService(RestTemplate restTemplate, AccountService accountService) {
        super(restTemplate);
        this.accountService = (AccountService)Validate.notNull((Object)accountService, (String)"account service");
    }

    public PageableList<AuditEvent> listAuditEvents(String domainId) {
        return this.listAuditEvents(domainId, (Page)new AuditEventPageRequest());
    }

    public PageableList<AuditEvent> listAuditEvents(String domainId, Page page) {
        Validate.notEmpty((CharSequence)domainId, (String)"domainId");
        Validate.notNull((Object)page, (String)"page");
        String uri = AuditEvent.ADMIN_URI_TEMPLATE.expand(new Object[]{domainId}).toString();
        return new MultiPageList<AuditEvent>(page, p -> this.doListAuditEvents(this.getAuditEventsUri((Page)p, uri)));
    }

    public PageableList<AuditEvent> listAuditEvents(Account account) {
        return this.listAuditEvents(account, (Page)new AuditEventPageRequest());
    }

    public PageableList<AuditEvent> listAuditEvents(Account account, Page page) {
        Validate.notNull((Object)account, (String)"account");
        Validate.notEmpty((CharSequence)account.getId(), (String)"account.id");
        Validate.notNull((Object)page, (String)"page");
        String uri = AuditEvent.USER_URI_TEMPLATE.expand(new Object[]{account.getId()}).toString();
        return new MultiPageList<AuditEvent>(page, p -> this.doListAuditEvents(this.getAuditEventsUri((Page)p, uri)));
    }

    public PageableList<AuditEvent> listAuditEvents() {
        return this.listAuditEvents((Page)new AuditEventPageRequest());
    }

    public PageableList<AuditEvent> listAuditEvents(Page page) {
        Validate.notNull((Object)page, (String)"page");
        Account account = this.accountService.getCurrent();
        return this.listAuditEvents(account, page);
    }

    private AuditEvents doListAuditEvents(String uri) {
        try {
            return (AuditEvents)((Object)this.restTemplate.getForObject(uri, AuditEvents.class, new Object[0]));
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.UNAUTHORIZED.value() == e.getStatusCode()) {
                throw new AuditEventsForbiddenException(e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to list audit events: " + uri);
        }
    }

    private String getAuditEventsUri(Page page, String uri) {
        return page.updateWithPageParams(UriComponentsBuilder.fromUriString((String)uri)).build().toUriString();
    }
}

