/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.io.IOException;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
class AttributeSort {
    static final String PK = "pk";
    static final String BY_USED_DF = "byUsedDF";
    private final String value;
    private final boolean linkType;

    AttributeSort(String value) {
        this(value, false);
    }

    AttributeSort(String value, boolean linkType) {
        this.value = (String)Validate.notEmpty((CharSequence)value, (String)"value");
        this.linkType = linkType;
    }

    String getValue() {
        return this.value;
    }

    boolean isLinkType() {
        return this.linkType;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    static class Serializer
    extends JsonSerializer<AttributeSort> {
        Serializer() {
        }

        public void serialize(AttributeSort value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value.linkType) {
                gen.writeStartObject();
                gen.writeFieldName("df");
                gen.writeStartObject();
                gen.writeStringField("uri", value.getValue());
                gen.writeEndObject();
                gen.writeEndObject();
            } else {
                gen.writeString(value.getValue());
            }
        }
    }

    static class Deserializer
    extends JsonDeserializer<AttributeSort> {
        Deserializer() {
        }

        public AttributeSort deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode root = (JsonNode)p.readValueAsTree();
            Validate.notNull((Object)root, (String)"jsonNode");
            if (root.isTextual()) {
                return new AttributeSort(root.textValue());
            }
            if (root.isObject()) {
                return new AttributeSort(root.findValue("uri").textValue(), true);
            }
            throw ctxt.mappingException("Only textual or object node expected but %s node found", new Object[]{root.getNodeType().name()});
        }
    }
}

