/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Meta;
import com.gooddata.md.Queryable;
import com.gooddata.util.GoodDataToStringBuilder;

@JsonTypeName(value="column")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
public class Column
extends AbstractObj
implements Queryable {
    public static final String TYPE_PK = "pk";
    public static final String TYPE_INPUT_PK = "inputpk";
    public static final String TYPE_FK = "fk";
    public static final String TYPE_FACT = "fact";
    public static final String TYPE_DISPLAY_FORM = "displayForm";
    private final Content content;

    private Column(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    public String getTableUri() {
        return this.content.getTable();
    }

    public String getType() {
        return this.content.getColumnType();
    }

    public String getDBName() {
        return this.content.getColumnDBName();
    }

    public boolean isPk() {
        return TYPE_PK.equals(this.getType());
    }

    public boolean isInputPk() {
        return TYPE_INPUT_PK.equals(this.getType());
    }

    public boolean isFk() {
        return TYPE_FK.equals(this.getType());
    }

    public boolean isFact() {
        return TYPE_FACT.equals(this.getType());
    }

    public boolean isDisplayForm() {
        return TYPE_DISPLAY_FORM.equals(this.getType());
    }

    @Override
    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Content {
        private final String table;
        private final String columnDBName;
        private final String columnType;

        @JsonCreator
        private Content(@JsonProperty(value="table") String table, @JsonProperty(value="columnDBName") String columnDBName, @JsonProperty(value="columnType") String columnType) {
            this.table = table;
            this.columnDBName = columnDBName;
            this.columnType = columnType;
        }

        public String getTable() {
            return this.table;
        }

        public String getColumnDBName() {
            return this.columnDBName;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

