/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.warehouse;

import com.gooddata.AbstractPollHandler;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.GoodDataSettings;
import com.gooddata.PollResult;
import com.gooddata.collections.MultiPageList;
import com.gooddata.collections.Page;
import com.gooddata.collections.PageRequest;
import com.gooddata.collections.PageableList;
import com.gooddata.util.Validate;
import com.gooddata.warehouse.Warehouse;
import com.gooddata.warehouse.WarehouseNotFoundException;
import com.gooddata.warehouse.WarehouseS3Credentials;
import com.gooddata.warehouse.WarehouseS3CredentialsException;
import com.gooddata.warehouse.WarehouseS3CredentialsList;
import com.gooddata.warehouse.WarehouseS3CredentialsNotFoundException;
import com.gooddata.warehouse.WarehouseSchema;
import com.gooddata.warehouse.WarehouseSchemaNotFoundException;
import com.gooddata.warehouse.WarehouseSchemas;
import com.gooddata.warehouse.WarehouseTask;
import com.gooddata.warehouse.WarehouseUser;
import com.gooddata.warehouse.WarehouseUserNotFoundException;
import com.gooddata.warehouse.WarehouseUsers;
import com.gooddata.warehouse.Warehouses;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class WarehouseService
extends AbstractService {
    private static final String DEFAULT_SCHEMA_NAME = "default";

    public WarehouseService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    @Deprecated
    public WarehouseService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public FutureResult<Warehouse> createWarehouse(Warehouse warehouse) {
        WarehouseTask task;
        Validate.notNull((Object)warehouse, (String)"warehouse");
        try {
            task = (WarehouseTask)this.restTemplate.postForObject("/gdc/datawarehouse/instances", (Object)warehouse, WarehouseTask.class, new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create Warehouse", e);
        }
        if (task == null) {
            throw new GoodDataException("Empty response when Warehouse POSTed to API");
        }
        return new PollResult<Warehouse>(this, new AbstractPollHandler<WarehouseTask, Warehouse>(task.getPollUri(), WarehouseTask.class, Warehouse.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.CREATED.equals((Object)response.getStatusCode());
            }

            @Override
            protected void onFinish() {
                if (!((Warehouse)this.getResult()).isEnabled()) {
                    throw new GoodDataException("Created warehouse, uri: " + ((Warehouse)this.getResult()).getUri() + " is not enabled!");
                }
            }

            @Override
            public void handlePollResult(WarehouseTask pollResult) {
                try {
                    Warehouse warehouse = (Warehouse)WarehouseService.this.restTemplate.getForObject(pollResult.getWarehouseUri(), Warehouse.class, new Object[0]);
                    this.setResult(warehouse);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new GoodDataException("Warehouse creation finished, but can't get created warehouse, uri: " + pollResult.getWarehouseUri(), e);
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to create warehouse", (Throwable)e);
            }
        });
    }

    public void removeWarehouse(Warehouse warehouse) {
        Validate.notNull((Object)warehouse, (String)"warehouse");
        Validate.notNull((Object)warehouse.getUri(), (String)"warehouse.uri");
        try {
            this.restTemplate.delete(warehouse.getUri(), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to delete Warehouse, uri: " + warehouse.getUri(), e);
        }
    }

    public Warehouse getWarehouseByUri(String uri) {
        Validate.notEmpty((CharSequence)uri, (String)"uri");
        try {
            return (Warehouse)this.restTemplate.getForObject(uri, Warehouse.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new WarehouseNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get Warehouse instance " + uri, (Throwable)e);
        }
    }

    public Warehouse getWarehouseById(String id) {
        Validate.notEmpty((CharSequence)id, (String)"id");
        return this.getWarehouseByUri(WarehouseService.uriFromId(id));
    }

    private static String uriFromId(String id) {
        return Warehouse.TEMPLATE.expand(new Object[]{id}).toString();
    }

    public PageableList<Warehouse> listWarehouses() {
        return this.listWarehouses((Page)new PageRequest());
    }

    public PageableList<Warehouse> listWarehouses(Page startPage) {
        Validate.notNull((Object)startPage, (String)"startPage");
        return new MultiPageList<Warehouse>(startPage, page -> this.listWarehouses(this.getWarehousesUri((Page)page)));
    }

    private URI getWarehousesUri() {
        return URI.create("/gdc/datawarehouse/instances");
    }

    private URI getWarehousesUri(Page page) {
        return page.getPageUri(UriComponentsBuilder.fromUri((URI)this.getWarehousesUri()));
    }

    private PageableList<Warehouse> listWarehouses(URI uri) {
        try {
            Warehouses result = (Warehouses)((Object)this.restTemplate.getForObject(uri, Warehouses.class));
            if (result == null) {
                return new PageableList();
            }
            return result;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list Warehouses", e);
        }
    }

    public PageableList<WarehouseUser> listWarehouseUsers(Warehouse warehouse) {
        return this.listWarehouseUsers(warehouse, (Page)new PageRequest());
    }

    public PageableList<WarehouseUser> listWarehouseUsers(Warehouse warehouse, Page startPage) {
        Validate.notNull((Object)warehouse, (String)"warehouse");
        Validate.notNull((Object)warehouse.getId(), (String)"warehouse.id");
        Validate.notNull((Object)startPage, (String)"startPage");
        return new MultiPageList<WarehouseUser>(startPage, page -> this.listWarehouseUsers(warehouse, this.getWarehouseUsersUri(warehouse, (Page)page)));
    }

    private URI getWarehouseUsersUri(Warehouse warehouse) {
        return WarehouseUsers.TEMPLATE.expand(new Object[]{warehouse.getId()});
    }

    private URI getWarehouseUsersUri(Warehouse warehouse, Page page) {
        return page.getPageUri(UriComponentsBuilder.fromUri((URI)this.getWarehouseUsersUri(warehouse)));
    }

    private PageableList<WarehouseUser> listWarehouseUsers(Warehouse warehouse, URI uri) {
        try {
            WarehouseUsers result = (WarehouseUsers)((Object)this.restTemplate.getForObject(uri, WarehouseUsers.class));
            return result == null ? new PageableList() : result;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list users of warehouse " + warehouse.getId(), e);
        }
    }

    public FutureResult<WarehouseUser> addUserToWarehouse(Warehouse warehouse, WarehouseUser user) {
        WarehouseTask task;
        Validate.notNull((Object)user, (String)"user");
        Validate.notNull((Object)warehouse, (String)"warehouse");
        Validate.notNull((Object)warehouse.getId(), (String)"warehouse.id");
        try {
            task = (WarehouseTask)this.restTemplate.postForObject("/gdc/datawarehouse/instances/{id}/users", (Object)user, WarehouseTask.class, new Object[]{warehouse.getId()});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable add user to warehouse " + warehouse.getId(), e);
        }
        if (task == null) {
            throw new GoodDataException("Empty response when user POSTed to API");
        }
        return new PollResult<WarehouseUser>(this, new AbstractPollHandler<WarehouseTask, WarehouseUser>(task.getPollUri(), WarehouseTask.class, WarehouseUser.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.CREATED.equals((Object)response.getStatusCode());
            }

            @Override
            public void handlePollResult(WarehouseTask pollResult) {
                try {
                    WarehouseUser newUser = (WarehouseUser)WarehouseService.this.restTemplate.getForObject(pollResult.getWarehouseUserUri(), WarehouseUser.class, new Object[0]);
                    this.setResult(newUser);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new GoodDataException("User added to warehouse, but can't get it back, uri: " + pollResult.getWarehouseUserUri(), e);
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to add user to warehouse", (Throwable)e);
            }
        });
    }

    public FutureResult<Void> removeUserFromWarehouse(WarehouseUser user) {
        WarehouseTask task;
        Validate.notNull((Object)user, (String)"user");
        Validate.notNull((Object)user.getUri(), (String)"user.uri");
        try {
            task = (WarehouseTask)this.restTemplate.exchange(user.getUri(), HttpMethod.DELETE, null, WarehouseTask.class, new Object[0]).getBody();
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new WarehouseUserNotFoundException(user.getUri(), e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to remove Warehouse user from instance " + user.getUri(), (Throwable)e);
        }
        if (task == null) {
            throw new GoodDataException("Empty response when user removed");
        }
        return new PollResult<Void>(this, new AbstractPollHandler<WarehouseTask, Void>(task.getPollUri(), WarehouseTask.class, Void.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.CREATED.equals((Object)response.getStatusCode());
            }

            @Override
            public void handlePollResult(WarehouseTask pollResult) {
                this.setResult(null);
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to remove user from warehouse", (Throwable)e);
            }
        });
    }

    public Warehouse updateWarehouse(Warehouse toUpdate) {
        Validate.notNull((Object)toUpdate, (String)"warehouse");
        Validate.notNull((Object)toUpdate.getUri(), (String)"warehouse.uri");
        try {
            this.restTemplate.put(toUpdate.getUri(), (Object)toUpdate, new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to update Warehouse, uri: " + toUpdate.getUri());
        }
        return this.getWarehouseByUri(toUpdate.getUri());
    }

    public PageableList<WarehouseSchema> listWarehouseSchemas(Warehouse warehouse) {
        return this.listWarehouseSchemas(warehouse, (Page)new PageRequest());
    }

    public PageableList<WarehouseSchema> listWarehouseSchemas(Warehouse warehouse, Page startPage) {
        return new MultiPageList<WarehouseSchema>(startPage, page -> this.listWarehouseSchemas(this.getWarehouseSchemasUri(warehouse, (Page)page)));
    }

    private URI getWarehouseSchemasUri(Warehouse warehouse) {
        Validate.notNull((Object)warehouse, (String)"warehouse");
        Validate.notNull((Object)warehouse.getId(), (String)"warehouse.id");
        return WarehouseSchemas.TEMPLATE.expand(new Object[]{warehouse.getId()});
    }

    private URI getWarehouseSchemasUri(Warehouse warehouse, Page page) {
        Validate.notNull((Object)page, (String)"page");
        return page.getPageUri(UriComponentsBuilder.fromUri((URI)this.getWarehouseSchemasUri(warehouse)));
    }

    private PageableList<WarehouseSchema> listWarehouseSchemas(URI uri) {
        try {
            WarehouseSchemas result = (WarehouseSchemas)((Object)this.restTemplate.getForObject(uri, WarehouseSchemas.class));
            if (result == null) {
                return new PageableList();
            }
            return result;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list Warehouse schemas", e);
        }
    }

    public WarehouseSchema getWarehouseSchemaByName(Warehouse warehouse, String name) {
        Validate.notNull((Object)warehouse, (String)"warehouse");
        Validate.notNull((Object)warehouse.getId(), (String)"warehouse.id");
        Validate.notEmpty((CharSequence)name, (String)"name");
        String uri = WarehouseSchema.TEMPLATE.expand(new Object[]{warehouse.getId(), name}).toString();
        return this.getWarehouseSchemaByUri(uri);
    }

    public WarehouseSchema getWarehouseSchemaByUri(String uri) {
        Validate.notEmpty((CharSequence)uri, (String)"uri");
        try {
            return (WarehouseSchema)this.restTemplate.getForObject(uri, WarehouseSchema.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new WarehouseSchemaNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get Warehouse instance " + uri, (Throwable)e);
        }
    }

    public WarehouseSchema getDefaultWarehouseSchema(Warehouse warehouse) {
        return this.getWarehouseSchemaByName(warehouse, DEFAULT_SCHEMA_NAME);
    }

    public PageableList<WarehouseS3Credentials> listWarehouseS3Credentials(Warehouse warehouse) {
        Validate.notNull((Object)warehouse, (String)"warehouse");
        String uri = this.getWarehouseS3CredentialsListUri(warehouse).toString();
        try {
            WarehouseS3CredentialsList result = (WarehouseS3CredentialsList)((Object)this.restTemplate.getForObject(uri, WarehouseS3CredentialsList.class, new Object[0]));
            if (result == null) {
                return new PageableList();
            }
            return result;
        }
        catch (GoodDataException | RestClientException e) {
            throw new WarehouseS3CredentialsException(uri, "Unable to list Warehouse S3 credentials at " + uri, (Exception)e);
        }
    }

    public WarehouseS3Credentials getWarehouseS3Credentials(Warehouse warehouse, String region, String accessKey) {
        Validate.notNull((Object)warehouse, (String)"warehouse");
        Validate.notEmpty((CharSequence)region, (String)"region");
        Validate.notEmpty((CharSequence)accessKey, (String)"accessKey");
        String uri = this.getWarehouseS3CredentialsUri(warehouse, region, accessKey).toString();
        try {
            return (WarehouseS3Credentials)this.restTemplate.getForObject(uri, WarehouseS3Credentials.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new WarehouseS3CredentialsNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new WarehouseS3CredentialsException(uri, "Unable to get Warehouse S3 credentials " + uri, (Exception)((Object)e));
        }
    }

    public FutureResult<WarehouseS3Credentials> addS3Credentials(Warehouse warehouse, WarehouseS3Credentials s3Credentials) {
        Validate.notNull((Object)warehouse, (String)"warehouse");
        Validate.notEmpty((CharSequence)warehouse.getId(), (String)"warehouse.id");
        Validate.notNull((Object)s3Credentials, (String)"s3Credentials");
        WarehouseTask task = this.createWarehouseTask("/gdc/datawarehouse/instances/{id}/s3", HttpMethod.POST, s3Credentials, this.createUpdateHttpEntity(s3Credentials), warehouse.getId());
        String newCredentialsUri = WarehouseS3Credentials.TEMPLATE.expand(new Object[]{warehouse.getId(), s3Credentials.getRegion(), s3Credentials.getAccessKey()}).toString();
        return new PollResult<WarehouseS3Credentials>(this, this.createS3PollHandler(newCredentialsUri, task, "add"));
    }

    public FutureResult<WarehouseS3Credentials> updateS3Credentials(WarehouseS3Credentials s3Credentials) {
        Validate.notNull((Object)s3Credentials, (String)"s3Credentials");
        Validate.notNull((Object)s3Credentials.getUri(), (String)"s3Credentials.links.self");
        WarehouseTask task = this.createWarehouseTask(s3Credentials.getUri(), HttpMethod.PUT, s3Credentials, this.createUpdateHttpEntity(s3Credentials), new Object[0]);
        return new PollResult<WarehouseS3Credentials>(this, this.createS3PollHandler(s3Credentials.getUri(), task, "update"));
    }

    public FutureResult<Void> removeS3Credentials(WarehouseS3Credentials s3Credentials) {
        Validate.notNull((Object)s3Credentials, (String)"s3Credentials");
        Validate.notNull((Object)s3Credentials.getUri(), (String)"s3Credentials.links.self");
        HttpEntity emptyRequestEntity = new HttpEntity((MultiValueMap)new HttpHeaders());
        WarehouseTask task = this.createWarehouseTask(s3Credentials.getUri(), HttpMethod.DELETE, s3Credentials, (HttpEntity<MappingJacksonValue>)emptyRequestEntity, new Object[0]);
        return new PollResult<Void>(this, this.createS3PollHandler(s3Credentials.getUri(), task, Void.class, "delete"));
    }

    private WarehouseTask createWarehouseTask(String targetUri, HttpMethod httpMethod, WarehouseS3Credentials s3Credentials, HttpEntity<MappingJacksonValue> requestEntity, Object ... args) {
        try {
            ResponseEntity taskHttpEntity = this.restTemplate.exchange(targetUri, httpMethod, requestEntity, WarehouseTask.class, args);
            if (taskHttpEntity == null || taskHttpEntity.getBody() == null) {
                throw new WarehouseS3CredentialsException(targetUri, String.format("Empty response when trying to %s S3 credentials via API", httpMethod.name()));
            }
            return (WarehouseTask)taskHttpEntity.getBody();
        }
        catch (GoodDataException | RestClientException e) {
            String expandedTargetUri = new UriTemplate(targetUri).expand(args).toString();
            throw new WarehouseS3CredentialsException(targetUri, String.format("Unable to %s S3 credentials %s with region: %s, access key: %s", httpMethod.name(), expandedTargetUri, s3Credentials.getRegion(), s3Credentials.getAccessKey()), (Exception)e);
        }
    }

    private HttpEntity<MappingJacksonValue> createUpdateHttpEntity(WarehouseS3Credentials s3Credentials) {
        MappingJacksonValue jacksonValue = new MappingJacksonValue((Object)s3Credentials);
        jacksonValue.setSerializationView(WarehouseS3Credentials.UpdateView.class);
        return new HttpEntity((Object)jacksonValue);
    }

    private AbstractPollHandler<WarehouseTask, WarehouseS3Credentials> createS3PollHandler(String credentialsUri, WarehouseTask task, String action) {
        return this.createS3PollHandler(credentialsUri, task, WarehouseS3Credentials.class, action);
    }

    private <R> AbstractPollHandler<WarehouseTask, R> createS3PollHandler(final String credentialsUri, WarehouseTask task, Class<R> resultClass, final String action) {
        return new AbstractPollHandler<WarehouseTask, R>(task.getPollUri(), WarehouseTask.class, resultClass){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                HttpStatus expectedStatus = "add".equals(action) ? HttpStatus.CREATED : HttpStatus.OK;
                return response.getStatusCode() == expectedStatus;
            }

            @Override
            public void handlePollResult(WarehouseTask pollResult) {
                String uri = pollResult.getWarehouseS3CredentialsUri();
                try {
                    Object result = WarehouseService.this.restTemplate.getForObject(uri, this.resultClass, new Object[0]);
                    this.setResult(result);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new WarehouseS3CredentialsException(uri, String.format("Attempt to %s S3 credentials in warehouse failed, can't get the result, uri: %s", action, uri), (Exception)e);
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new WarehouseS3CredentialsException(credentialsUri, String.format("Unable to %s S3 credentials in warehouse, uri: %s", action, credentialsUri), (Exception)((Object)e));
            }
        };
    }

    private URI getWarehouseS3CredentialsListUri(Warehouse warehouse) {
        Validate.notEmpty((CharSequence)warehouse.getId(), (String)"warehouse.id");
        return WarehouseS3CredentialsList.TEMPLATE.expand(new Object[]{warehouse.getId()});
    }

    private URI getWarehouseS3CredentialsUri(Warehouse warehouse, String region, String accessKey) {
        Validate.notEmpty((CharSequence)warehouse.getId(), (String)"warehouse.id");
        return WarehouseS3Credentials.TEMPLATE.expand(new Object[]{warehouse.getId(), region, accessKey});
    }
}

