/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.executeafm.resultspec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.executeafm.resultspec.TotalItem;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Dimension {
    public static final String MEASURE_GROUP = "measureGroup";
    private final String name;
    private final List<String> itemIdentifiers;
    private Set<TotalItem> totals;

    @JsonCreator
    public Dimension(@JsonProperty(value="name") String name, @JsonProperty(value="itemIdentifiers") List<String> itemIdentifiers, @JsonProperty(value="totals") Set<TotalItem> totals) {
        this.name = (String)Validate.notEmpty((CharSequence)name, (String)"name");
        this.itemIdentifiers = itemIdentifiers;
        this.totals = totals;
    }

    public Dimension(String name, String ... itemIdentifiers) {
        this(name, Arrays.asList(itemIdentifiers), null);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getItemIdentifiers() {
        return this.itemIdentifiers;
    }

    public Set<TotalItem> getTotals() {
        return this.totals;
    }

    public void setTotals(Set<TotalItem> totals) {
        this.totals = totals;
    }

    public Dimension addTotal(TotalItem total) {
        if (this.totals == null) {
            this.setTotals(new HashSet<TotalItem>());
        }
        this.totals.add((TotalItem)Validate.notNull((Object)total, (String)"total"));
        return this;
    }

    public Set<TotalItem> findTotals(String attrIdentifier) {
        Predicate<TotalItem> filter = t -> ((String)Validate.notNull((Object)attrIdentifier, (String)"attrIdentifier")).equals(t.getAttributeIdentifier());
        if (this.totals == null) {
            return Collections.emptySet();
        }
        return this.totals.stream().filter(filter).collect(Collectors.toSet());
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

