/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.util.GoodDataToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Status {
    private final String code;
    private final String detail;
    private final String description;

    @JsonCreator
    Status(@JsonProperty(value="code") String code, @JsonProperty(value="detail") String detail, @JsonProperty(value="description") String description) {
        this.code = code;
        this.detail = detail;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public boolean isFinished() {
        return Code.SYNCHRONIZED.name().equalsIgnoreCase(this.code) || this.isFailed();
    }

    @JsonIgnore
    public boolean isFailed() {
        return Code.ERROR.name().equalsIgnoreCase(this.code) || Code.USER_ERROR.name().equalsIgnoreCase(this.code);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    public static enum Code {
        NEW,
        SCHEDULED,
        DOWNLOADING,
        DOWNLOADED,
        TRANSFORMING,
        TRANSFORMED,
        UPLOADING,
        UPLOADED,
        SYNCHRONIZED,
        ERROR,
        USER_ERROR;

    }
}

