/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.executeafm.result;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.executeafm.result.AttributeHeaderItem;
import com.gooddata.executeafm.result.Paging;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="executionResult")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExecutionResult {
    private final Paging paging;
    @JsonProperty(value="data")
    private List data;
    private List<List<List<AttributeHeaderItem>>> attributeHeaderItems;
    private List<List<List<String>>> totals;

    public ExecutionResult(String[] data, Paging paging) {
        this.data = Arrays.asList((Object[])Validate.notNull((Object)data, (String)"data"));
        this.paging = (Paging)Validate.notNull((Object)paging, (String)"paging");
    }

    public ExecutionResult(String[][] data, Paging paging) {
        this.data = Arrays.stream((Object[])Validate.notNull((Object)data, (String)"data")).map(Arrays::asList).collect(Collectors.toList());
        this.paging = (Paging)Validate.notNull((Object)paging, (String)"paging");
    }

    @JsonCreator
    ExecutionResult(@JsonProperty(value="data") List data, @JsonProperty(value="paging") Paging paging, @JsonProperty(value="attributeHeaderItems") List<List<List<AttributeHeaderItem>>> attributeHeaderItems, @JsonProperty(value="totals") List<List<List<String>>> totals) {
        this.data = data;
        this.paging = paging;
        this.attributeHeaderItems = attributeHeaderItems;
        this.totals = totals;
    }

    public Paging getPaging() {
        return this.paging;
    }

    public List<List<List<AttributeHeaderItem>>> getAttributeHeaderItems() {
        return this.attributeHeaderItems;
    }

    public void setAttributeHeaderItems(List<List<List<AttributeHeaderItem>>> attributeHeaderItems) {
        this.attributeHeaderItems = attributeHeaderItems;
    }

    public void addAttributeHeaderItems(List<List<AttributeHeaderItem>> items) {
        if (this.attributeHeaderItems == null) {
            this.setAttributeHeaderItems(new ArrayList<List<List<AttributeHeaderItem>>>());
        }
        this.attributeHeaderItems.add(items);
    }

    public List<List<List<String>>> getTotals() {
        return this.totals;
    }

    public void setTotals(List<List<List<String>>> totals) {
        this.totals = totals;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

