/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.AttributeSort;
import com.gooddata.md.DisplayForm;
import com.gooddata.md.Key;
import com.gooddata.md.Meta;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NestedAttribute
extends AbstractObj {
    @JsonProperty(value="content")
    private final Content content;

    @JsonCreator
    protected NestedAttribute(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    @JsonIgnore
    public Collection<DisplayForm> getDisplayForms() {
        return this.content.getDisplayForms();
    }

    @JsonIgnore
    public Collection<Key> getPrimaryKeys() {
        return this.content.getPk();
    }

    @JsonIgnore
    public Collection<Key> getForeignKeys() {
        return this.content.getFk();
    }

    @JsonIgnore
    public DisplayForm getDefaultDisplayForm() {
        return this.getDisplayForms().iterator().next();
    }

    @Deprecated
    @JsonIgnore
    public String getDimensionLink() {
        return this.getDimensionUri();
    }

    @JsonIgnore
    public String getDimensionUri() {
        return this.content.getDimensionUri();
    }

    public boolean hasDimension() {
        return this.getDimensionUri() != null;
    }

    @JsonIgnore
    public Collection<String> getRelations() {
        return this.content.getRelations();
    }

    @JsonIgnore
    public String getDirection() {
        return this.content.getDirection();
    }

    @JsonIgnore
    public String getSort() {
        return this.content.getSort() != null ? this.content.getSort().getValue() : null;
    }

    @JsonIgnore
    public boolean isSortedByLinkedDf() {
        return this.content.getSort() != null && this.content.getSort().isLinkType();
    }

    @JsonIgnore
    public boolean isSortedByUsedDf() {
        return this.content.getSort() != null && AttributeSort.BY_USED_DF.equals(this.content.getSort().getValue());
    }

    @JsonIgnore
    public boolean isSortedByPk() {
        return this.content.getSort() != null && AttributeSort.PK.equals(this.content.getSort().getValue());
    }

    @JsonIgnore
    public String getType() {
        return this.content.getType();
    }

    @JsonIgnore
    public Collection<String> getCompositeAttribute() {
        return this.content.getCompositeAttribute();
    }

    @JsonIgnore
    public Collection<String> getCompositeAttributePk() {
        return this.content.getCompositeAttributePk();
    }

    @Deprecated
    @JsonIgnore
    public String getDrillDownStepDisplayFormLink() {
        return this.getDrillDownStepDisplayFormUri();
    }

    @JsonIgnore
    public String getDrillDownStepDisplayFormUri() {
        return this.content.getDrillDownStepDisplayFormUri();
    }

    @Deprecated
    @JsonIgnore
    public String getLinkedDisplayFormLink() {
        return this.getLinkedDisplayFormUri();
    }

    @JsonIgnore
    public String getLinkedDisplayFormUri() {
        return this.content.getLinkedDisplayFormUri();
    }

    @JsonIgnore
    public Collection<String> getFolders() {
        return this.content.getFolders();
    }

    @JsonIgnore
    public Collection<String> getGrain() {
        return this.content.getGrain();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected static class Content {
        private final Collection<Key> pk;
        private final Collection<Key> fk;
        private final Collection<DisplayForm> displayForms;
        private final String dimension;
        private final String direction;
        private final AttributeSort sort;
        private final String type;
        private final Collection<String> rel;
        private final Collection<String> compositeAttribute;
        private final Collection<String> compositeAttributePk;
        private final String drillDownStepAttributeDF;
        private final String linkedDisplayFormUri;
        private final Collection<String> folders;
        private final Collection<String> grain;

        @JsonCreator
        protected Content(@JsonProperty(value="pk") Collection<Key> pk, @JsonProperty(value="fk") Collection<Key> fk, @JsonProperty(value="displayForms") Collection<DisplayForm> displayForms, @JsonProperty(value="dimension") String dimension, @JsonProperty(value="direction") String direction, @JsonProperty(value="sort") AttributeSort sort, @JsonProperty(value="type") String type, @JsonProperty(value="rel") Collection<String> rel, @JsonProperty(value="compositeAttribute") Collection<String> compositeAttribute, @JsonProperty(value="compositeAttributePk") Collection<String> compositeAttributePk, @JsonProperty(value="drillDownStepAttributeDF") String drillDownStepAttributeDF, @JsonProperty(value="linkAttributeDF") String linkedDisplayFormUri, @JsonProperty(value="folders") Collection<String> folders, @JsonProperty(value="grain") Collection<String> grain) {
            this.pk = pk;
            this.fk = fk;
            this.displayForms = displayForms;
            this.dimension = dimension;
            this.direction = direction;
            this.sort = sort;
            this.type = type;
            this.rel = rel;
            this.compositeAttribute = compositeAttribute;
            this.compositeAttributePk = compositeAttributePk;
            this.drillDownStepAttributeDF = drillDownStepAttributeDF;
            this.linkedDisplayFormUri = linkedDisplayFormUri;
            this.folders = folders;
            this.grain = grain;
        }

        public Collection<Key> getPk() {
            return this.pk;
        }

        public Collection<Key> getFk() {
            return this.fk;
        }

        public Collection<DisplayForm> getDisplayForms() {
            return this.displayForms;
        }

        @Deprecated
        @JsonIgnore
        public String getDimensionLink() {
            return this.getDimensionUri();
        }

        @JsonProperty(value="dimension")
        public String getDimensionUri() {
            return this.dimension;
        }

        public String getDirection() {
            return this.direction;
        }

        public AttributeSort getSort() {
            return this.sort;
        }

        public String getType() {
            return this.type;
        }

        @JsonProperty(value="rel")
        public Collection<String> getRelations() {
            return this.rel;
        }

        public Collection<String> getCompositeAttribute() {
            return this.compositeAttribute;
        }

        public Collection<String> getCompositeAttributePk() {
            return this.compositeAttributePk;
        }

        @Deprecated
        @JsonIgnore
        public String getDrillDownStepDisplayFormLink() {
            return this.getDrillDownStepDisplayFormUri();
        }

        @JsonProperty(value="drillDownStepAttributeDF")
        public String getDrillDownStepDisplayFormUri() {
            return this.drillDownStepAttributeDF;
        }

        @Deprecated
        @JsonIgnore
        public String getLinkedDisplayFormLink() {
            return this.getLinkedDisplayFormUri();
        }

        @JsonProperty(value="linkAttributeDF")
        public String getLinkedDisplayFormUri() {
            return this.linkedDisplayFormUri;
        }

        public Collection<String> getFolders() {
            return this.folders;
        }

        public Collection<String> getGrain() {
            return this.grain;
        }
    }
}

