/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.notification;

import com.gooddata.AbstractService;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.GoodDataSettings;
import com.gooddata.account.Account;
import com.gooddata.notification.Channel;
import com.gooddata.notification.ProjectEvent;
import com.gooddata.notification.Subscription;
import com.gooddata.project.Project;
import com.gooddata.util.Validate;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class NotificationService
extends AbstractService {
    public NotificationService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    @Deprecated
    public NotificationService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public void triggerEvent(Project project, ProjectEvent event) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)event, (String)"event");
        try {
            this.restTemplate.postForEntity("/gdc/projects/{projectId}/notifications/events", (Object)event, Void.class, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to post project event.", e);
        }
    }

    public Channel createChannel(Account account, Channel channel) {
        Validate.notNull((Object)account, (String)"account");
        Validate.notNull((Object)channel, (String)"channel");
        Validate.notEmpty((CharSequence)account.getId(), (String)"account.id");
        try {
            return (Channel)this.restTemplate.postForObject("/gdc/account/profile/{id}/channelConfigurations", (Object)channel, Channel.class, new Object[]{account.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to create channel", e);
        }
    }

    public void removeChannel(Channel channel) {
        Validate.notNull((Object)channel, (String)"channel");
        Validate.notNull((Object)channel.getMeta(), (String)"channel.meta");
        Validate.notEmpty((CharSequence)channel.getMeta().getUri(), (String)"channel.meta.uri");
        try {
            this.restTemplate.delete(channel.getMeta().getUri(), new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to delete channel", e);
        }
    }

    public Subscription createSubscription(Project project, Account account, Subscription subscription) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)account, (String)"account");
        Validate.notNull((Object)subscription, (String)"subscription");
        Validate.notEmpty((CharSequence)project.getId(), (String)"project.id");
        Validate.notEmpty((CharSequence)account.getId(), (String)"account.id");
        try {
            return (Subscription)this.restTemplate.postForObject("/gdc/projects/{project}/users/{user}/subscriptions", (Object)subscription, Subscription.class, new Object[]{project.getId(), account.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to create subscription", e);
        }
    }

    public void removeSubscription(Subscription subscription) {
        Validate.notNull((Object)subscription, (String)"subscription");
        Validate.notNull((Object)subscription.getMeta(), (String)"subscription.meta");
        Validate.notEmpty((CharSequence)subscription.getMeta().getUri(), (String)"subscription.meta.uri");
        try {
            this.restTemplate.delete(subscription.getMeta().getUri(), new Object[0]);
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to delete subscription", e);
        }
    }
}

