/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.md.IdentifierAndUri;
import com.gooddata.util.GoodDataToStringBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class IdentifiersAndUris {
    public static final String URI = "/gdc/md/{projectId}/identifiers";
    private final List<IdentifierAndUri> identifiersAndUris;

    @JsonCreator
    IdentifiersAndUris(@JsonProperty(value="identifiers") List<IdentifierAndUri> identifiersAndUris) {
        this.identifiersAndUris = identifiersAndUris;
    }

    public List<String> getUris() {
        return this.identifiersAndUris.stream().map(IdentifierAndUri::getUri).collect(Collectors.toList());
    }

    public Map<String, String> asMap() {
        HashMap<String, String> identifiersToUris = new HashMap<String, String>();
        for (IdentifierAndUri idAndUri : this.identifiersAndUris) {
            identifiersToUris.put(idAndUri.getIdentifier(), idAndUri.getUri());
        }
        return Collections.unmodifiableMap(identifiersToUris);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

