/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.util.GoodDataToStringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="projectModelDiff")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ModelDiff {
    private final List<UpdateScript> updateScripts;

    @JsonCreator
    ModelDiff(@JsonProperty(value="updateScripts") List<UpdateScript> updateScripts) {
        this.updateScripts = updateScripts == null ? Collections.emptyList() : updateScripts;
    }

    ModelDiff(UpdateScript ... updateScripts) {
        this(Arrays.asList(updateScripts));
    }

    List<UpdateScript> getUpdateScripts() {
        return Collections.unmodifiableList(this.updateScripts);
    }

    public List<String> getUpdateMaql() {
        if (this.updateScripts.isEmpty()) {
            return Collections.emptyList();
        }
        UpdateScript chosenScript = this.getUpdateScriptByFlags(true, false);
        if (chosenScript != null) {
            return Collections.unmodifiableList(chosenScript.getMaqlChunks());
        }
        chosenScript = this.getUpdateScriptByFlags(false, false);
        if (chosenScript != null) {
            return Collections.unmodifiableList(chosenScript.getMaqlChunks());
        }
        chosenScript = this.getUpdateScriptByFlags(true, true);
        if (chosenScript != null) {
            return Collections.unmodifiableList(chosenScript.getMaqlChunks());
        }
        return Collections.unmodifiableList(this.updateScripts.get(0).getMaqlChunks());
    }

    private UpdateScript getUpdateScriptByFlags(boolean preserveData, boolean cascadeDrops) {
        UpdateScript result = null;
        for (UpdateScript script : this.updateScripts) {
            if (script.isPreserveData() != preserveData || script.isCascadeDrops() != cascadeDrops) continue;
            result = script;
        }
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonTypeName(value="updateScript")
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class UpdateScript {
        private final List<String> maqlChunks;
        private final Boolean preserveData;
        private final Boolean cascadeDrops;

        @JsonCreator
        UpdateScript(@JsonProperty(value="preserveData") Boolean preserveData, @JsonProperty(value="cascadeDrops") Boolean cascadeDrops, @JsonProperty(value="maqlDdlChunks") List<String> maqlChunks) {
            this.preserveData = preserveData;
            this.cascadeDrops = cascadeDrops;
            this.maqlChunks = maqlChunks == null ? Collections.emptyList() : maqlChunks;
        }

        UpdateScript(boolean preserveData, boolean cascadeDrops, String ... maqlChunks) {
            this((Boolean)preserveData, (Boolean)cascadeDrops, Arrays.asList(maqlChunks));
        }

        public List<String> getMaqlChunks() {
            return this.maqlChunks;
        }

        public Boolean isPreserveData() {
            return this.preserveData;
        }

        public Boolean isCascadeDrops() {
            return this.cascadeDrops;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

