/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.util;

import com.gooddata.util.Validate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.springframework.util.StreamUtils;

public abstract class ZipHelper {
    public static void zip(File file, OutputStream output) throws IOException {
        ZipHelper.zip(file, output, false);
    }

    public static void zip(File file, OutputStream output, boolean includeRoot) throws IOException {
        Validate.notNull((Object)file, (String)"file");
        Validate.notNull((Object)output, (String)"output");
        if (ZipHelper.isZipped(file)) {
            try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                StreamUtils.copy((InputStream)fis, (OutputStream)output);
            }
        }
        try (ZipOutputStream zos = new ZipOutputStream(output);){
            if (file.isDirectory()) {
                ZipHelper.zipDir(includeRoot ? file.getParentFile().toPath() : file.toPath(), file, zos);
            } else {
                ZipHelper.zipFile(file.getParentFile().toPath(), file, zos);
            }
        }
    }

    private static void zipDir(Path rootPath, File dir, ZipOutputStream zos) throws IOException {
        for (File file : (File[])Validate.notNull((Object)dir.listFiles(), (String)"listed files")) {
            if (file.isDirectory()) {
                ZipHelper.zipDir(rootPath, file, zos);
                continue;
            }
            ZipHelper.zipFile(rootPath, file, zos);
        }
    }

    private static void zipFile(Path rootPath, File file, ZipOutputStream zos) throws IOException {
        ZipEntry ze = new ZipEntry(rootPath.relativize(file.toPath()).toString());
        zos.putNextEntry(ze);
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            StreamUtils.copy((InputStream)fis, (OutputStream)zos);
        }
        zos.closeEntry();
    }

    /*
     * Exception decompiling
     */
    private static boolean isZipped(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

