/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md.visualization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.executeafm.Execution;
import com.gooddata.executeafm.UriObjQualifier;
import com.gooddata.executeafm.afm.FilterItem;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Meta;
import com.gooddata.md.Queryable;
import com.gooddata.md.Updatable;
import com.gooddata.md.visualization.Bucket;
import com.gooddata.md.visualization.CollectionType;
import com.gooddata.md.visualization.Measure;
import com.gooddata.md.visualization.VOSimpleMeasureDefinition;
import com.gooddata.md.visualization.VisualizationAttribute;
import com.gooddata.md.visualization.VisualizationClass;
import com.gooddata.md.visualization.VisualizationConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="visualizationObject")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VisualizationObject
extends AbstractObj
implements Queryable,
Updatable {
    static final String NAME = "visualizationObject";
    private Content content;

    @JsonCreator
    private VisualizationObject(@JsonProperty(value="content") Content content, @JsonProperty(value="meta") Meta meta) {
        super(meta);
        this.content = (Content)Validate.notNull((Object)content);
    }

    @JsonIgnore
    public List<Measure> getMeasures() {
        return this.getContent().getMeasures();
    }

    public Measure getMeasure(String localIdentifier) {
        return this.getMeasures().stream().filter(measure -> measure.getLocalIdentifier().equals(localIdentifier)).findFirst().orElse(null);
    }

    @JsonIgnore
    public List<Measure> getSimpleMeasures() {
        return this.getMeasures().stream().filter(measure -> measure.getDefinition() instanceof VOSimpleMeasureDefinition).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<VisualizationAttribute> getAttributes() {
        return this.getContent().getAttributes();
    }

    public VisualizationAttribute getAttribute(String localIdentifier) {
        return this.getAttributes().stream().filter(attribute -> attribute.getLocalIdentifier().equals(localIdentifier)).findFirst().orElse(null);
    }

    @JsonIgnore
    public VisualizationAttribute getAttributeFromCollection(CollectionType type) {
        return this.getContent().getBuckets().stream().filter(bucket -> type.isValueOf(bucket.getLocalIdentifier())).findFirst().map(Bucket::getOnlyAttribute).orElse(null);
    }

    @JsonIgnore
    public boolean hasMeasures() {
        return !this.getMeasures().isEmpty();
    }

    @JsonIgnore
    public boolean hasDerivedMeasure() {
        return this.getMeasures().stream().anyMatch(measure -> measure.isPop() || measure.hasComputeRatio());
    }

    @JsonIgnore
    public String getItemById(String id) {
        Map<String, String> referenceItems = this.getReferenceItems();
        if (referenceItems != null) {
            return referenceItems.get(id);
        }
        return null;
    }

    @JsonIgnore
    public VisualizationAttribute getStack() {
        return this.getAttributeFromCollection(CollectionType.STACK);
    }

    @JsonIgnore
    public VisualizationAttribute getView() {
        return this.getAttributeFromCollection(CollectionType.VIEW);
    }

    @JsonIgnore
    public VisualizationAttribute getSegment() {
        return this.getAttributeFromCollection(CollectionType.SEGMENT);
    }

    @JsonIgnore
    public VisualizationAttribute getTrend() {
        return this.getAttributeFromCollection(CollectionType.TREND);
    }

    @JsonIgnore
    public String getVisualizationClassUri() {
        return this.getContent().getVisualizationClassUri();
    }

    @JsonIgnore
    public List<Bucket> getBuckets() {
        return this.getContent().getBuckets();
    }

    @JsonIgnore
    public void setBuckets(List<Bucket> buckets) {
        this.content.setBuckets(buckets);
    }

    @JsonIgnore
    public List<FilterItem> getFilters() {
        return this.getContent().getFilters();
    }

    @JsonIgnore
    public void setFilters(List<FilterItem> filters) {
        this.content.setFilters(filters);
    }

    @JsonIgnore
    public String getProperties() {
        return this.getContent().getProperties();
    }

    @JsonIgnore
    public void setProperties(String properties) {
        this.content.setProperties(properties);
    }

    @JsonIgnore
    public Map<String, String> getReferenceItems() {
        return this.getContent().getReferenceItems();
    }

    @JsonIgnore
    public void setReferenceItems(Map<String, String> referenceItems) {
        this.content.setReferenceItems(referenceItems);
    }

    public UriObjQualifier getVisualizationClass() {
        return this.content.getVisualizationClass();
    }

    public void setVisualizationClass(UriObjQualifier uri) {
        this.content.setVisualizationClass(uri);
    }

    @JsonIgnore
    public Execution convertToExecution(Function<String, VisualizationClass> visualizationClassgetter) {
        return VisualizationConverter.convertToExecution(this, visualizationClassgetter);
    }

    private Content getContent() {
        return this.content;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Content
    implements Serializable {
        private static final long serialVersionUID = 2895359822118041504L;
        private UriObjQualifier visualizationClass;
        private List<Bucket> buckets;
        private List<FilterItem> filters;
        private String properties;
        private Map<String, String> referenceItems;

        @JsonCreator
        private Content(@JsonProperty(value="visualizationClass") UriObjQualifier visualizationClass, @JsonProperty(value="buckets") List<Bucket> buckets, @JsonProperty(value="filters") List<FilterItem> filters, @JsonProperty(value="properties") String properties, @JsonProperty(value="references") Map<String, String> referenceItems) {
            this.visualizationClass = (UriObjQualifier)Validate.notNull((Object)visualizationClass);
            this.buckets = (List)Validate.notNull(buckets);
            this.filters = filters;
            this.properties = properties;
            this.referenceItems = referenceItems;
        }

        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        @JsonIgnore
        public List<VisualizationAttribute> getAttributes() {
            return this.buckets.stream().flatMap(bucket -> bucket.getItems().stream()).filter(VisualizationAttribute.class::isInstance).map(VisualizationAttribute.class::cast).collect(Collectors.toList());
        }

        public void setVisualizationClass(UriObjQualifier visualizationClass) {
            this.visualizationClass = visualizationClass;
        }

        public void setBuckets(List<Bucket> buckets) {
            this.buckets = buckets;
        }

        public void setFilters(List<FilterItem> filters) {
            this.filters = filters;
        }

        public void setProperties(String properties) {
            this.properties = properties;
        }

        public void setReferenceItems(Map<String, String> referenceItems) {
            this.referenceItems = referenceItems;
        }

        @JsonIgnore
        public List<Measure> getMeasures() {
            return this.buckets.stream().flatMap(bucket -> bucket.getItems().stream()).filter(Measure.class::isInstance).map(Measure.class::cast).collect(Collectors.toList());
        }

        @JsonIgnore
        public String getVisualizationClassUri() {
            return this.visualizationClass.getUri();
        }

        public List<FilterItem> getFilters() {
            if (this.filters == null) {
                return new ArrayList<FilterItem>();
            }
            return this.filters;
        }

        public String getProperties() {
            return this.properties;
        }

        public UriObjQualifier getVisualizationClass() {
            return this.visualizationClass;
        }

        public Map<String, String> getReferenceItems() {
            return this.referenceItems;
        }
    }
}

