/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.executeafm.afm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.gooddata.executeafm.ObjQualifier;
import com.gooddata.executeafm.UriObjQualifier;
import com.gooddata.executeafm.afm.MeasureDefinition;
import com.gooddata.executeafm.afm.ObjIdentifierUtilities;
import com.gooddata.executeafm.afm.ObjQualifierConverter;
import com.gooddata.executeafm.afm.OverPeriodDateAttribute;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonRootName(value="overPeriodMeasure")
public class OverPeriodMeasureDefinition
implements MeasureDefinition,
Serializable {
    private static final long serialVersionUID = -8904516814279504098L;
    static final String NAME = "overPeriodMeasure";
    private final String measureIdentifier;
    private final List<OverPeriodDateAttribute> dateAttributes;

    @JsonCreator
    public OverPeriodMeasureDefinition(@JsonProperty(value="measureIdentifier") String measureIdentifier, @JsonProperty(value="dateAttributes") List<OverPeriodDateAttribute> dateAttributes) {
        this.measureIdentifier = (String)Validate.notNull((Object)measureIdentifier, (String)"measureIdentifier");
        this.dateAttributes = (List)Validate.notEmpty(dateAttributes, (String)"dateAttributes");
    }

    @Override
    @Deprecated
    public ObjQualifier getObjQualifier() {
        throw new UnsupportedOperationException("The method is not supported by the object!");
    }

    @Override
    public Collection<ObjQualifier> getObjQualifiers() {
        return this.dateAttributes.stream().map(OverPeriodDateAttribute::getAttribute).collect(Collectors.toSet());
    }

    @Override
    @Deprecated
    public MeasureDefinition withObjUriQualifier(UriObjQualifier uriQualifier) {
        throw new UnsupportedOperationException("The method is not supported by the object!");
    }

    @Override
    public MeasureDefinition withObjUriQualifiers(ObjQualifierConverter objQualifierConverter) {
        Validate.notNull((Object)objQualifierConverter, (String)"objQualifierConverter");
        return new OverPeriodMeasureDefinition(this.measureIdentifier, this.copyAttributesWithUriQualifiers(objQualifierConverter));
    }

    private List<OverPeriodDateAttribute> copyAttributesWithUriQualifiers(ObjQualifierConverter objQualifierConverter) {
        return this.dateAttributes.stream().map(attribute -> this.copyWithUriQualifier((OverPeriodDateAttribute)attribute, objQualifierConverter)).collect(Collectors.toList());
    }

    private OverPeriodDateAttribute copyWithUriQualifier(OverPeriodDateAttribute attribute, ObjQualifierConverter objQualifierConverter) {
        return ObjIdentifierUtilities.copyIfNecessary(attribute, attribute.getAttribute(), uriObjQualifier -> new OverPeriodDateAttribute((ObjQualifier)uriObjQualifier, attribute.getPeriodsAgo()), objQualifierConverter);
    }

    @Override
    public boolean isAdHoc() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverPeriodMeasureDefinition that = (OverPeriodMeasureDefinition)o;
        return Objects.equals(this.measureIdentifier, that.measureIdentifier) && Objects.equals(this.dateAttributes, that.dateAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.measureIdentifier, this.dateAttributes);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    public String getMeasureIdentifier() {
        return this.measureIdentifier;
    }

    public List<OverPeriodDateAttribute> getDateAttributes() {
        return this.dateAttributes;
    }
}

