/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md.maintenance;

import com.gooddata.AbstractPollHandler;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataRestException;
import com.gooddata.GoodDataSettings;
import com.gooddata.PollResult;
import com.gooddata.gdc.TaskStatus;
import com.gooddata.gdc.UriResponse;
import com.gooddata.md.maintenance.ExportImportException;
import com.gooddata.md.maintenance.PartialMdArtifact;
import com.gooddata.md.maintenance.PartialMdExport;
import com.gooddata.md.maintenance.PartialMdExportToken;
import com.gooddata.project.Project;
import com.gooddata.util.Validate;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ExportImportService
extends AbstractService {
    public ExportImportService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    @Deprecated
    public ExportImportService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public FutureResult<PartialMdExportToken> partialExport(Project project, final PartialMdExport export) {
        PartialMdArtifact partialMdArtifact;
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)export, (String)"export");
        try {
            partialMdArtifact = (PartialMdArtifact)this.restTemplate.postForObject("/gdc/md/{projectId}/maintenance/partialmdexport", (Object)export, PartialMdArtifact.class, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ExportImportException("Unable to export metadata from objects " + export.getUris() + ".", e);
        }
        return new PollResult<PartialMdExportToken>(this, new AbstractPollHandler<TaskStatus, PartialMdExportToken>(partialMdArtifact.getStatusUri(), TaskStatus.class, PartialMdExportToken.class){

            @Override
            public void handlePollResult(TaskStatus pollResult) {
                if (!pollResult.isSuccess()) {
                    throw new ExportImportException("Partial metadata export failed with errors: " + pollResult.getMessages());
                }
                this.setResult(new PartialMdExportToken(partialMdArtifact.getToken(), export.isExportAttributeProperties()));
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ExportImportException("Unable to to export partial metadata.", e);
            }
        });
    }

    public FutureResult<Void> partialImport(Project project, PartialMdExportToken mdExportToken) {
        UriResponse importResponse;
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)mdExportToken, (String)"mdExportToken");
        try {
            importResponse = (UriResponse)this.restTemplate.postForObject("/gdc/md/{projectId}/maintenance/partialmdimport", (Object)mdExportToken, UriResponse.class, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ExportImportException("Unable to import partial metadata to project '" + project.getId() + "' with token '" + mdExportToken.getToken() + "'.", e);
        }
        return new PollResult<Void>(this, new AbstractPollHandler<TaskStatus, Void>(importResponse.getUri(), TaskStatus.class, Void.class){

            @Override
            public void handlePollResult(TaskStatus pollResult) {
                if (!pollResult.isSuccess()) {
                    throw new ExportImportException("Partial metadata import failed with errors: " + pollResult.getMessages());
                }
                this.setResult(null);
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ExportImportException("Unable to import partial metadata.", e);
            }
        });
    }
}

