/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.md.Meta;
import com.gooddata.notification.Channel;
import com.gooddata.notification.MessageTemplate;
import com.gooddata.notification.Trigger;
import com.gooddata.notification.TriggerCondition;
import com.gooddata.util.GoodDataToStringBuilder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.web.util.UriTemplate;

@JsonTypeName(value="subscription")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Subscription {
    public static final String URI = "/gdc/projects/{project}/users/{user}/subscriptions";
    public static final UriTemplate URI_TEMPLATE = new UriTemplate("/gdc/projects/{project}/users/{user}/subscriptions");
    private final List<Trigger> triggers;
    private final TriggerCondition condition;
    private final MessageTemplate messageTemplate;
    private final MessageTemplate subjectTemplate;
    private final List<String> channels;
    private final Meta meta;

    public Subscription(List<Trigger> triggers, List<Channel> channels, TriggerCondition condition, MessageTemplate messageTemplate, String title) {
        this(triggers, channels, condition, messageTemplate, null, title);
    }

    public Subscription(List<Trigger> triggers, List<Channel> channels, TriggerCondition condition, MessageTemplate messageTemplate, MessageTemplate subjectTemplate, String title) {
        this((List<Trigger>)((List)Validate.notNull(triggers, (String)"triggers", (Object[])new Object[0])), (TriggerCondition)Validate.notNull((Object)condition, (String)"condition", (Object[])new Object[0]), (MessageTemplate)Validate.notNull((Object)messageTemplate, (String)"messageTemplate", (Object[])new Object[0]), subjectTemplate, ((List)Validate.notNull(channels, (String)"channels", (Object[])new Object[0])).stream().map(e -> e.getMeta().getUri()).collect(Collectors.toList()), new Meta((String)Validate.notEmpty((CharSequence)title, (String)"title", (Object[])new Object[0])));
    }

    @JsonCreator
    Subscription(@JsonProperty(value="triggers") List<Trigger> triggers, @JsonProperty(value="condition") TriggerCondition condition, @JsonProperty(value="message") MessageTemplate messageTemplate, @JsonProperty(value="subject") MessageTemplate subjectTemplate, @JsonProperty(value="channels") List<String> channels, @JsonProperty(value="meta") Meta meta) {
        this.triggers = triggers;
        this.condition = condition;
        this.messageTemplate = messageTemplate;
        this.subjectTemplate = subjectTemplate;
        this.channels = channels;
        this.meta = meta;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public TriggerCondition getCondition() {
        return this.condition;
    }

    @JsonProperty(value="message")
    public MessageTemplate getTemplate() {
        return this.messageTemplate;
    }

    @JsonProperty(value="subject")
    public MessageTemplate getSubjectTemplate() {
        return this.subjectTemplate;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

