/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.authentication;

import com.gooddata.Authentication;
import com.gooddata.GoodDataEndpoint;
import com.gooddata.http.client.GoodDataHttpClient;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.http.client.SimpleSSTRetrievalStrategy;
import com.gooddata.util.Validate;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class SstAuthentication
implements Authentication {
    private final String sst;

    public SstAuthentication(String sst) {
        this.sst = Validate.notEmpty(sst, "sst");
    }

    @Override
    public HttpClient createHttpClient(GoodDataEndpoint endpoint, HttpClientBuilder builder) {
        Validate.notNull(endpoint, "endpoint");
        Validate.notNull(builder, "builder");
        CloseableHttpClient httpClient = builder.build();
        SimpleSSTRetrievalStrategy strategy = new SimpleSSTRetrievalStrategy(this.sst);
        HttpHost httpHost = new HttpHost(endpoint.getHostname(), endpoint.getPort(), endpoint.getProtocol());
        return new GoodDataHttpClient((HttpClient)httpClient, httpHost, (SSTRetrievalStrategy)strategy);
    }
}

