/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.gooddata.util.Validate;
import java.net.URI;
import java.util.List;
import org.springframework.web.util.UriComponentsBuilder;

public class UriPrefixer {
    private final URI uriPrefix;

    public UriPrefixer(URI uriPrefix) {
        this.uriPrefix = Validate.notNull(uriPrefix, "uriPrefix");
    }

    public UriPrefixer(String uriPrefix) {
        this(URI.create(uriPrefix));
    }

    public URI getUriPrefix() {
        return this.uriPrefix;
    }

    public URI mergeUris(URI uri) {
        Validate.notNull(uri, "uri");
        return UriComponentsBuilder.fromUri((URI)this.uriPrefix).pathSegment(UriPrefixer.getPathSegments(uri)).query(uri.getRawQuery()).fragment(uri.getRawFragment()).build(true).toUri();
    }

    private static String[] getPathSegments(URI uri) {
        List pathSegments = UriComponentsBuilder.fromPath((String)uri.getRawPath()).build(true).getPathSegments();
        return pathSegments.toArray(new String[pathSegments.size()]);
    }

    public URI mergeUris(String uri) {
        Validate.notEmpty(uri, "uri");
        return this.mergeUris(URI.create(uri));
    }
}

