/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.gooddata.util.Validate;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class UriPrefixer {
    private final URI uriPrefix;

    public UriPrefixer(URI uriPrefix) {
        this.uriPrefix = Validate.notNull(uriPrefix, "uriPrefix");
    }

    public UriPrefixer(String uriPrefix) {
        this(URI.create(uriPrefix));
    }

    public URI getUriPrefix() {
        return this.uriPrefix;
    }

    public URI mergeUris(URI uri) {
        Validate.notNull(uri, "uri");
        String path = uri.getRawPath();
        String[] pathSegments = UriPrefixer.getPathSegments(path);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this.uriPrefix).pathSegment(pathSegments).query(uri.getRawQuery()).fragment(uri.getRawFragment());
        if (StringUtils.endsWith((CharSequence)path, (CharSequence)"/")) {
            builder.path("/");
        }
        return builder.build(true).toUri();
    }

    private static String[] getPathSegments(String path) {
        List pathSegments = UriComponentsBuilder.fromPath((String)path).build(true).getPathSegments();
        return pathSegments.toArray(new String[pathSegments.size()]);
    }

    public URI mergeUris(String uri) {
        Validate.notEmpty(uri, "uri");
        return this.mergeUris(URI.create(uri));
    }
}

