/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.authentication;

import com.gooddata.Authentication;
import com.gooddata.GoodDataEndpoint;
import com.gooddata.http.client.GoodDataHttpClient;
import com.gooddata.http.client.LoginSSTRetrievalStrategy;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.util.Validate;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class LoginPasswordAuthentication
implements Authentication {
    private final String login;
    private final String password;

    public LoginPasswordAuthentication(String login, String password) {
        this.login = Validate.notEmpty(login, "login");
        this.password = Validate.notEmpty(password, "password");
    }

    @Override
    public HttpClient createHttpClient(GoodDataEndpoint endpoint, HttpClientBuilder builder) {
        Validate.notNull(endpoint, "endpoint");
        Validate.notNull(builder, "builder");
        CloseableHttpClient httpClient = builder.build();
        LoginSSTRetrievalStrategy strategy = new LoginSSTRetrievalStrategy(this.login, this.password);
        HttpHost httpHost = new HttpHost(endpoint.getHostname(), endpoint.getPort(), endpoint.getProtocol());
        return new GoodDataHttpClient((HttpClient)httpClient, httpHost, (SSTRetrievalStrategy)strategy);
    }
}

