/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.collections;

import com.gooddata.collections.Page;
import com.gooddata.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

class UriPage
implements Page {
    private final UriComponents pageUri;

    public UriPage(String pageUri) {
        try {
            this.pageUri = UriComponentsBuilder.fromUriString((String)UriUtils.decode((String)Validate.notNull(pageUri, "pageUri"), (String)"UTF-8")).build();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public URI getPageUri(UriComponentsBuilder uriBuilder) {
        return this.pageUri.toUri();
    }

    @Override
    public UriComponentsBuilder updateWithPageParams(UriComponentsBuilder uriBuilder) {
        Validate.notNull(uriBuilder, "uriBuilder");
        for (Map.Entry entry : this.pageUri.getQueryParams().entrySet()) {
            uriBuilder.replaceQueryParam((String)entry.getKey(), ((List)entry.getValue()).toArray());
        }
        return uriBuilder;
    }
}

