/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.collections;

import com.gooddata.collections.Page;
import com.gooddata.util.Validate;
import java.net.URI;
import org.springframework.web.util.UriComponentsBuilder;

public class PageRequest
implements Page {
    public static final Integer DEFAULT_LIMIT = 100;
    private String offset;
    private int limit;

    public PageRequest() {
        this(null, (int)DEFAULT_LIMIT);
    }

    public PageRequest(int offset, int limit) {
        this(String.valueOf(offset), limit);
    }

    public PageRequest(String offset, int limit) {
        this.offset = offset;
        this.limit = limit;
    }

    public PageRequest(int limit) {
        this(null, limit);
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getSanitizedLimit() {
        return this.limit > 0 ? this.limit : DEFAULT_LIMIT;
    }

    public int getSanitizedLimit(int max) {
        int limit = this.getSanitizedLimit();
        return limit < max ? limit : max;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public URI getPageUri(UriComponentsBuilder uriBuilder) {
        Validate.notNull(uriBuilder, "uriBuilder");
        UriComponentsBuilder copy = UriComponentsBuilder.fromUriString((String)uriBuilder.build().toUriString());
        return this.updateWithPageParams(copy).build().toUri();
    }

    @Override
    public UriComponentsBuilder updateWithPageParams(UriComponentsBuilder uriBuilder) {
        if (this.offset != null) {
            uriBuilder.replaceQueryParam("offset", new Object[]{this.offset});
        }
        uriBuilder.replaceQueryParam("limit", new Object[]{this.limit});
        return uriBuilder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageRequest that = (PageRequest)o;
        if (this.limit != that.limit) {
            return false;
        }
        return !(this.offset == null ? that.offset != null : !this.offset.equals(that.offset));
    }

    public int hashCode() {
        int result = this.offset != null ? this.offset.hashCode() : 0;
        result = 31 * result + this.limit;
        return result;
    }
}

