/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataload.processes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gooddata.dataload.processes.DataloadProcess;
import com.gooddata.dataload.processes.ScheduleState;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.ISODateTimeDeserializer;
import com.gooddata.util.Validate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="schedule")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Schedule {
    public static final String URI = "/gdc/projects/{projectId}/schedules/{scheduleId}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/schedules/{scheduleId}");
    private static final String SELF_LINK = "self";
    private static final String EXECUTIONS_LINK = "executions";
    private static final String MSETL_TYPE = "MSETL";
    private static final String PROCESS_ID = "PROCESS_ID";
    private static final String EXECUTABLE = "EXECUTABLE";
    private final String type;
    private String state;
    private String cron;
    private String timezone;
    private Integer reschedule;
    private String triggerScheduleId;
    private String name;
    private final DateTime nextExecutionTime;
    private final int consecutiveFailedExecutionCount;
    private final Map<String, String> params;
    private final Map<String, String> links;

    public Schedule(DataloadProcess process, String executable, String cron) {
        this(process, executable);
        this.cron = Validate.notEmpty(cron, "cron");
    }

    public Schedule(DataloadProcess process, String executable, Schedule triggerSchedule) {
        this(process, executable);
        this.triggerScheduleId = Validate.notEmpty(Validate.notNull(triggerSchedule, "triggerSchedule").getId(), "triggerSchedule ID");
    }

    private Schedule(DataloadProcess process, String executable) {
        Validate.notNull(process, "process");
        this.type = MSETL_TYPE;
        this.state = ScheduleState.ENABLED.name();
        this.params = new HashMap<String, String>();
        this.params.put(PROCESS_ID, process.getId());
        process.validateExecutable(executable);
        this.nextExecutionTime = null;
        this.consecutiveFailedExecutionCount = 0;
        this.params.put(EXECUTABLE, executable);
        this.links = Collections.emptyMap();
    }

    @JsonCreator
    private Schedule(@JsonProperty(value="type") String type, @JsonProperty(value="state") String state, @JsonProperty(value="cron") String cron, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="nextExecutionTime") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime nextExecutionTime, @JsonProperty(value="consecutiveFailedExecutionCount") int consecutiveFailedExecutionCount, @JsonProperty(value="params") Map<String, String> params, @JsonProperty(value="reschedule") Integer reschedule, @JsonProperty(value="triggerScheduleId") String triggerScheduleId, @JsonProperty(value="name") String name, @JsonProperty(value="links") Map<String, String> links) {
        this.type = type;
        this.state = state;
        this.cron = cron;
        this.timezone = timezone;
        this.nextExecutionTime = nextExecutionTime;
        this.consecutiveFailedExecutionCount = consecutiveFailedExecutionCount;
        this.params = params;
        this.reschedule = reschedule;
        this.triggerScheduleId = triggerScheduleId;
        this.name = name;
        this.links = links;
    }

    public String getType() {
        return this.type;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = Validate.notEmpty(state, "state");
    }

    @JsonIgnore
    public void setState(ScheduleState state) {
        this.state = Validate.notNull(state, "state").name();
    }

    @JsonIgnore
    public boolean isEnabled() {
        return ScheduleState.ENABLED.name().equals(this.state);
    }

    @JsonIgnore
    public String getProcessId() {
        return this.params.get(PROCESS_ID);
    }

    public void setProcessId(DataloadProcess process) {
        this.params.put(PROCESS_ID, process.getId());
    }

    @JsonIgnore
    public String getExecutable() {
        return this.params.get(EXECUTABLE);
    }

    public void setExecutable(DataloadProcess process, String executable) {
        Validate.notNull(executable, "executable");
        Validate.notNull(process, "process").validateExecutable(executable);
        this.params.put(EXECUTABLE, executable);
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public void addParam(String key, String value) {
        Validate.notEmpty(key, "param");
        Validate.notNull(value, "value");
        this.params.put(key, value);
    }

    public void removeParam(String paramKey) {
        Validate.notEmpty(paramKey, "paramKey!");
        this.params.remove(paramKey);
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = Validate.notEmpty(cron, "cron");
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @JsonProperty(value="reschedule")
    public Integer getRescheduleInMinutes() {
        return this.reschedule;
    }

    @JsonIgnore
    public Duration getReschedule() {
        return this.reschedule != null ? Duration.standardMinutes((long)this.getRescheduleInMinutes().intValue()) : null;
    }

    public void setReschedule(Duration reschedule) {
        this.reschedule = Validate.notNull(reschedule, "reschedule").toStandardMinutes().getMinutes();
    }

    public String getTriggerScheduleId() {
        return this.triggerScheduleId;
    }

    public void setTriggerScheduleId(String triggerScheduleId) {
        this.triggerScheduleId = triggerScheduleId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public void setTimezone(DateTimeZone timezone) {
        this.timezone = Validate.notNull(timezone, "timezone").getID();
    }

    @JsonIgnore
    public DateTime getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    @JsonIgnore
    public int getConsecutiveFailedExecutionCount() {
        return this.consecutiveFailedExecutionCount;
    }

    @JsonIgnore
    public String getUri() {
        return Validate.notNullState(this.links, "links").get(SELF_LINK);
    }

    @JsonIgnore
    public String getId() {
        return (String)TEMPLATE.match(this.getUri()).get("scheduleId");
    }

    @JsonIgnore
    public String getExecutionsUri() {
        return Validate.notNullState(this.links, "links").get(EXECUTIONS_LINK);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }
}

