/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class GDDateDeserializer
extends JsonDeserializer<LocalDate> {
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).toFormatter().withZone(DateTimeZone.UTC);

    public LocalDate deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode root = (JsonNode)jp.readValueAsTree();
        if (root == null || root.isNull()) {
            return null;
        }
        return FORMATTER.parseLocalDate(root.textValue());
    }
}

