/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import com.gooddata.sdk.service.GoodDataRestProvider;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.account.AccountService;
import com.gooddata.sdk.service.auditevent.AuditEventService;
import com.gooddata.sdk.service.connector.ConnectorService;
import com.gooddata.sdk.service.dataload.OutputStageService;
import com.gooddata.sdk.service.dataload.processes.ProcessService;
import com.gooddata.sdk.service.dataset.DatasetService;
import com.gooddata.sdk.service.executeafm.ExecuteAfmService;
import com.gooddata.sdk.service.export.ExportService;
import com.gooddata.sdk.service.featureflag.FeatureFlagService;
import com.gooddata.sdk.service.gdc.DataStoreService;
import com.gooddata.sdk.service.gdc.GdcService;
import com.gooddata.sdk.service.lcm.LcmService;
import com.gooddata.sdk.service.md.MetadataService;
import com.gooddata.sdk.service.md.maintenance.ExportImportService;
import com.gooddata.sdk.service.notification.NotificationService;
import com.gooddata.sdk.service.project.ProjectService;
import com.gooddata.sdk.service.project.model.ModelService;
import com.gooddata.sdk.service.projecttemplate.ProjectTemplateService;
import com.gooddata.sdk.service.warehouse.WarehouseService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

class GoodDataServices {
    private final GoodDataRestProvider goodDataRestProvider;
    private final Logger logger = LoggerFactory.getLogger(GoodDataServices.class);
    private final AccountService accountService;
    private final ProjectService projectService;
    private final MetadataService metadataService;
    private final ModelService modelService;
    private final GdcService gdcService;
    private final DataStoreService dataStoreService;
    private final DatasetService datasetService;
    private final ConnectorService connectorService;
    private final ProcessService processService;
    private final WarehouseService warehouseService;
    private final NotificationService notificationService;
    private final ExportImportService exportImportService;
    private final FeatureFlagService featureFlagService;
    private final OutputStageService outputStageService;
    private final ProjectTemplateService projectTemplateService;
    private final ExportService exportService;
    private final AuditEventService auditEventService;
    private final ExecuteAfmService executeAfmService;
    private final LcmService lcmService;

    GoodDataServices(GoodDataRestProvider goodDataRestProvider) {
        this.goodDataRestProvider = goodDataRestProvider;
        this.accountService = new AccountService(this.getRestTemplate(), this.getSettings());
        this.projectService = new ProjectService(this.getRestTemplate(), this.accountService, this.getSettings());
        this.metadataService = new MetadataService(this.getRestTemplate(), this.getSettings());
        this.modelService = new ModelService(this.getRestTemplate(), this.getSettings());
        this.gdcService = new GdcService(this.getRestTemplate(), this.getSettings());
        this.exportService = new ExportService(this.getRestTemplate(), this.getSettings());
        this.warehouseService = new WarehouseService(this.getRestTemplate(), this.getSettings());
        this.connectorService = new ConnectorService(this.getRestTemplate(), this.projectService, this.getSettings());
        this.notificationService = new NotificationService(this.getRestTemplate(), this.getSettings());
        this.exportImportService = new ExportImportService(this.getRestTemplate(), this.getSettings());
        this.featureFlagService = new FeatureFlagService(this.getRestTemplate(), this.getSettings());
        this.outputStageService = new OutputStageService(this.getRestTemplate(), this.getSettings());
        this.projectTemplateService = new ProjectTemplateService(this.getRestTemplate(), this.getSettings());
        this.auditEventService = new AuditEventService(this.getRestTemplate(), this.accountService, this.getSettings());
        this.executeAfmService = new ExecuteAfmService(this.getRestTemplate(), this.getSettings());
        this.lcmService = new LcmService(this.getRestTemplate(), this.getSettings());
        Optional<DataStoreService> dataStoreService = goodDataRestProvider.getDataStoreService(() -> this.gdcService.getRootLinks().getUserStagingUri());
        if (dataStoreService.isPresent()) {
            this.dataStoreService = dataStoreService.get();
        } else {
            this.dataStoreService = null;
            this.logger.info("GoodDataRestProvider provided empty DataStoreService - WebDAV related operations are not supported");
        }
        this.datasetService = new DatasetService(this.getRestTemplate(), this.dataStoreService, this.getSettings());
        this.processService = new ProcessService(this.getRestTemplate(), this.accountService, this.dataStoreService, this.getSettings());
    }

    RestTemplate getRestTemplate() {
        return this.goodDataRestProvider.getRestTemplate();
    }

    GoodDataSettings getSettings() {
        return this.goodDataRestProvider.getSettings();
    }

    ProjectService getProjectService() {
        return this.projectService;
    }

    AccountService getAccountService() {
        return this.accountService;
    }

    MetadataService getMetadataService() {
        return this.metadataService;
    }

    ModelService getModelService() {
        return this.modelService;
    }

    GdcService getGdcService() {
        return this.gdcService;
    }

    DataStoreService getDataStoreService() {
        return this.dataStoreService;
    }

    DatasetService getDatasetService() {
        return this.datasetService;
    }

    ExportService getExportService() {
        return this.exportService;
    }

    ProcessService getProcessService() {
        return this.processService;
    }

    WarehouseService getWarehouseService() {
        return this.warehouseService;
    }

    ConnectorService getConnectorService() {
        return this.connectorService;
    }

    NotificationService getNotificationService() {
        return this.notificationService;
    }

    ExportImportService getExportImportService() {
        return this.exportImportService;
    }

    FeatureFlagService getFeatureFlagService() {
        return this.featureFlagService;
    }

    OutputStageService getOutputStageService() {
        return this.outputStageService;
    }

    ProjectTemplateService getProjectTemplateService() {
        return this.projectTemplateService;
    }

    AuditEventService getAuditEventService() {
        return this.auditEventService;
    }

    ExecuteAfmService getExecuteAfmService() {
        return this.executeAfmService;
    }

    LcmService getLcmService() {
        return this.lcmService;
    }
}

