/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.md.maintenance;

import com.gooddata.sdk.common.GoodDataRestException;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.gdc.TaskStatus;
import com.gooddata.sdk.model.gdc.UriResponse;
import com.gooddata.sdk.model.md.maintenance.PartialMdArtifact;
import com.gooddata.sdk.model.md.maintenance.PartialMdExport;
import com.gooddata.sdk.model.md.maintenance.PartialMdExportToken;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.service.AbstractPollHandler;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.FutureResult;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.PollResult;
import com.gooddata.sdk.service.md.maintenance.ExportImportException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ExportImportService
extends AbstractService {
    public ExportImportService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    public FutureResult<PartialMdExportToken> partialExport(Project project, final PartialMdExport export) {
        PartialMdArtifact partialMdArtifact;
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)export, (String)"export");
        try {
            partialMdArtifact = (PartialMdArtifact)this.restTemplate.postForObject("/gdc/md/{projectId}/maintenance/partialmdexport", (Object)export, PartialMdArtifact.class, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ExportImportException("Unable to export metadata from objects " + export.getUris() + ".", e);
        }
        return new PollResult<PartialMdExportToken>(this, new AbstractPollHandler<TaskStatus, PartialMdExportToken>(((PartialMdArtifact)Validate.notNullState((Object)partialMdArtifact, (String)"partial export response")).getStatusUri(), TaskStatus.class, PartialMdExportToken.class){

            @Override
            public void handlePollResult(TaskStatus pollResult) {
                if (!pollResult.isSuccess()) {
                    throw new ExportImportException("Partial metadata export failed with errors: " + pollResult.getMessages());
                }
                this.setResult(new PartialMdExportToken(partialMdArtifact.getToken(), export.isExportAttributeProperties()));
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ExportImportException("Unable to to export partial metadata.", e);
            }
        });
    }

    public FutureResult<Void> partialImport(Project project, PartialMdExportToken mdExportToken) {
        UriResponse importResponse;
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notNull((Object)mdExportToken, (String)"mdExportToken");
        try {
            importResponse = (UriResponse)this.restTemplate.postForObject("/gdc/md/{projectId}/maintenance/partialmdimport", (Object)mdExportToken, UriResponse.class, new Object[]{project.getId()});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ExportImportException("Unable to import partial metadata to project '" + project.getId() + "' with token '" + mdExportToken.getToken() + "'.", e);
        }
        return new PollResult<Void>(this, new AbstractPollHandler<TaskStatus, Void>(((UriResponse)Validate.notNullState((Object)importResponse, (String)"partial import response")).getUri(), TaskStatus.class, Void.class){

            @Override
            public void handlePollResult(TaskStatus pollResult) {
                if (!pollResult.isSuccess()) {
                    throw new ExportImportException("Partial metadata import failed with errors: " + pollResult.getMessages());
                }
                this.setResult(null);
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ExportImportException("Unable to import partial metadata.", e);
            }
        });
    }
}

