/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.executeafm;

import com.gooddata.sdk.common.GoodDataException;
import com.gooddata.sdk.common.GoodDataRestException;
import org.springframework.http.HttpStatus;

public class ExecutionResultException
extends GoodDataException {
    ExecutionResultException(GoodDataRestException cause) {
        super(ExecutionResultException.computeMessage(cause), (Throwable)cause);
    }

    private static String computeMessage(GoodDataRestException cause) {
        switch (HttpStatus.valueOf((int)cause.getStatusCode())) {
            case BAD_REQUEST: {
                return "AFM execution is not computable";
            }
            case GONE: {
                return "AFM execution result no longer available";
            }
            case PAYLOAD_TOO_LARGE: {
                return "AFM execution result is too large";
            }
        }
        return "AFM execution failed for unknown reason";
    }
}

