/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.hierarchicalconfig;

import com.gooddata.sdk.common.GoodDataException;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.hierarchicalconfig.ConfigItem;
import com.gooddata.sdk.model.hierarchicalconfig.ConfigItems;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.GoodDataSettings;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class HierarchicalConfigService
extends AbstractService {
    public static final UriTemplate PROJECT_CONFIG_ITEMS_TEMPLATE = new UriTemplate(ConfigItems.PROJECT_CONFIG_ITEMS_URI);
    public static final UriTemplate PROJECT_CONFIG_ITEM_TEMPLATE = new UriTemplate(ConfigItem.PROJECT_CONFIG_ITEM_URI);

    public HierarchicalConfigService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    public ConfigItems listProjectConfigItems(Project project) {
        Validate.notNull((Object)project, (String)"project");
        try {
            ConfigItems configItems = (ConfigItems)this.restTemplate.getForObject(PROJECT_CONFIG_ITEMS_TEMPLATE.expand(new Object[]{project.getId()}), ConfigItems.class);
            if (configItems == null) {
                throw new GoodDataException("empty response from API call");
            }
            return configItems;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list config items for project ID=" + project.getId(), e);
        }
    }

    public ConfigItem getProjectConfigItem(Project project, String configName) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notEmpty((CharSequence)configName, (String)"configName");
        try {
            String configUri = PROJECT_CONFIG_ITEM_TEMPLATE.expand(new Object[]{project.getId(), configName}).toString();
            return this.getProjectConfigItem(configUri);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to get project config item: " + configName, e);
        }
    }

    public ConfigItem setProjectConfigItem(Project project, ConfigItem configItem) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)configItem, (String)"configItem");
        try {
            String configUri = PROJECT_CONFIG_ITEM_TEMPLATE.expand(new Object[]{project.getId(), configItem.getName()}).toString();
            this.restTemplate.put(configUri, (Object)configItem, new Object[0]);
            return this.getProjectConfigItem(configUri);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to set project config item: " + configItem.getKey(), e);
        }
    }

    public void removeProjectConfigItem(ConfigItem configItem) {
        Validate.notNull((Object)configItem, (String)"configItem");
        Validate.notEmpty((CharSequence)configItem.getUri(), (String)"config item URI");
        try {
            this.restTemplate.delete(configItem.getUri(), new Object[0]);
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to remove project config item: " + configItem.getKey(), (Throwable)e);
        }
    }

    private ConfigItem getProjectConfigItem(String configUri) {
        ConfigItem configItem = (ConfigItem)this.restTemplate.getForObject(configUri, ConfigItem.class, new Object[0]);
        if (configItem == null) {
            throw new GoodDataException("Project config item cannot be retrieved from URI " + configUri);
        }
        return configItem;
    }
}

