/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.FutureResult;
import com.gooddata.sdk.service.PollHandler;
import java.util.concurrent.TimeUnit;

public final class PollResult<T>
implements FutureResult<T> {
    private final AbstractService service;
    private final PollHandler<?, T> handler;

    public PollResult(AbstractService service, PollHandler<?, T> handler) {
        this.service = (AbstractService)Validate.notNull((Object)service, (String)"service");
        this.handler = (PollHandler)Validate.notNull(handler, (String)"handler");
    }

    @Override
    public boolean isDone() {
        return this.handler.isDone() || this.service.pollOnce(this.handler);
    }

    @Override
    public T get() {
        return this.get(0L, null);
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        if (this.handler.isDone()) {
            return this.handler.getResult();
        }
        return this.service.poll(this.handler, timeout, unit);
    }

    @Override
    public String getPollingUri() {
        return this.handler.getPollingUri();
    }
}

